/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.github.jklingsporn.vertx.jooq.future.VertxDAO;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.plugin.jooq.JooqInfix;
import io.vertx.up.aiki.JooqAnalyzer;
import io.vertx.up.aiki.JooqCond;
import io.vertx.up.aiki.JooqReader;
import io.vertx.up.aiki.JooqWriter;
import io.vertx.up.aiki.Query;
import io.vertx.up.atom.query.Inquiry;
import io.vertx.up.eon.em.Format;
import io.vertx.up.log.Annal;
import io.zero.epic.fn.Fn;
import io.zero.epic.fn.wait.Case;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jooq.Condition;
import org.jooq.Operator;

public class UxJooq {
    private static final Annal LOGGER = Annal.get(UxJooq.class);
    private final transient Class<?> clazz;
    private final transient JooqAnalyzer analyzer;
    private final transient JooqWriter writer;
    private final transient JooqReader reader;
    private transient Format format = Format.JSON;

    <T> UxJooq(Class<T> clazz, VertxDAO vertxDAO) {
        this.clazz = clazz;
        this.analyzer = JooqAnalyzer.create(vertxDAO);
        this.reader = JooqReader.create(vertxDAO).on(this.analyzer);
        this.writer = JooqWriter.create(vertxDAO).on(this.analyzer).on(this.reader);
    }

    <T> UxJooq(Class<T> clazz) {
        this(clazz, (VertxDAO)JooqInfix.getDao(clazz));
    }

    public static Condition transform(JsonObject filters, Operator operator) {
        return JooqCond.transform(filters, operator, null);
    }

    public static Condition transform(JsonObject filters) {
        return JooqCond.transform(filters, null, null);
    }

    public UxJooq on(String pojo) {
        this.analyzer.bind(pojo, this.clazz);
        return this;
    }

    public UxJooq on(Format format) {
        this.format = format;
        return this;
    }

    public <T> Future<T> insertReturningPrimaryAsync(T entity, Consumer<Long> consumer) {
        return this.writer.insertReturningPrimaryAsync(entity, consumer);
    }

    public <T> Future<T> insertAsync(T entity) {
        return this.writer.insertAsync(entity);
    }

    public <T> T insert(T entity) {
        return this.writer.insert(entity);
    }

    public <T> Future<List<T>> insertAsync(List<T> entities) {
        return this.writer.insertAsync(entities);
    }

    public <T> List<T> insert(List<T> entities) {
        return this.writer.insert(entities);
    }

    public <T> Future<T> upsertReturningPrimaryAsync(JsonObject andFilters, T updated, Consumer<Long> consumer) {
        return this.fetchOneAndAsync(andFilters).compose(item -> Fn.match((Case.DefaultCase)Fn.fork(() -> this.updateAsync(this.analyzer.copyEntity(item, updated))), (Case[])new Case[]{Fn.branch((null == item ? 1 : 0) != 0, () -> this.insertReturningPrimaryAsync(updated, consumer))}));
    }

    public <T> Future<T> updateAsync(T entity) {
        return this.writer.updateAsync(entity);
    }

    public <T> T update(T entity) {
        return this.writer.update(entity);
    }

    public <T> Future<List<T>> updateAsync(List<T> entities) {
        return this.writer.updateAsync(entities);
    }

    public <T> List<T> update(List<T> entities) {
        return this.writer.update(entities);
    }

    public <ID> Future<Boolean> deleteByIdAsync(ID id) {
        return this.writer.deleteByIdAsync(id);
    }

    public <ID> Future<Boolean> deleteByIdAsync(ID ... ids) {
        return this.writer.deleteByIdAsync(Arrays.asList(ids));
    }

    public <ID> Boolean deleteById(ID id) {
        return this.writer.deleteById(id);
    }

    public <ID> Boolean deleteById(ID ... ids) {
        return this.writer.deleteById(Arrays.asList(ids));
    }

    public <T> Future<T> deleteAsync(T entity) {
        return this.writer.deleteAsync(entity);
    }

    public <T> T delete(T entity) {
        return this.writer.delete(entity);
    }

    public <T, ID> Future<Boolean> deleteAsync(JsonObject filters) {
        return this.writer.deleteAsync(filters, "");
    }

    public <T, ID> Boolean delete(JsonObject filters, String pojo) {
        return this.writer.delete(filters, pojo);
    }

    public <T, ID> Future<Boolean> deleteAsync(JsonObject filters, String pojo) {
        return this.writer.deleteAsync(filters, pojo);
    }

    public <T, ID> Boolean delete(JsonObject filters) {
        return this.writer.delete(filters, "");
    }

    public <T> Future<T> fetchOneAsync(String field, Object value) {
        return this.reader.fetchOneAsync(field, value);
    }

    public <T> T fetchOne(String field, Object value) {
        return this.reader.fetchOne(field, value);
    }

    public <T> Future<T> findByIdAsync(Object id) {
        return this.reader.findByIdAsync(id);
    }

    public <T> T findById(Object id) {
        return this.reader.findById(id);
    }

    public <T> Future<List<T>> findAllAsync() {
        return this.reader.findAllAsync();
    }

    public <T> List<T> findAll() {
        return this.reader.findAll();
    }

    public <T> Future<T> saveAsync(Object id, T updated) {
        return this.writer.saveAsync(id, target -> this.analyzer.copyEntity(target, updated));
    }

    public <T> T save(Object id, T updated) {
        return (T)this.writer.save(id, target -> this.analyzer.copyEntity(target, updated));
    }

    public <T> Future<T> saveAsync(Object id, Function<T, T> copyFun) {
        return this.writer.saveAsync(id, copyFun);
    }

    public <T> T save(Object id, Function<T, T> copyFun) {
        return this.writer.save(id, copyFun);
    }

    public Future<Boolean> existsByIdAsync(Object id) {
        return this.reader.existsByIdAsync(id);
    }

    public Boolean existsById(Object id) {
        return this.reader.existsById(id);
    }

    public <T> Future<Boolean> existsOneAsync(JsonObject andFilters) {
        return this.fetchOneAndAsync(andFilters).compose(item -> Future.succeededFuture((Object)(null != item ? 1 : 0)));
    }

    public <T> Boolean existsOne(JsonObject andFilters) {
        T result = this.fetchOneAnd(andFilters);
        return null != result;
    }

    public <T> Future<List<T>> fetchAsync(String field, Object value) {
        return this.reader.fetchAsync(field, value);
    }

    public <T> Future<List<T>> fetchInAsync(String field, Object ... value) {
        return this.reader.fetchInAsync(field, Arrays.asList(value));
    }

    public <T> Future<List<T>> fetchInAsync(String field, JsonArray values) {
        return this.reader.fetchInAsync(field, values.getList());
    }

    public <T> List<T> fetch(String field, Object value) {
        return this.reader.fetch(field, value);
    }

    public <T> List<T> fetchIn(String field, Object ... values) {
        return this.reader.fetchIn(field, Arrays.asList(values));
    }

    public <T> List<T> fetchIn(String field, JsonArray values) {
        return this.reader.fetchIn(field, values.getList());
    }

    public <T> Future<List<T>> findAsync(JsonObject filters) {
        return this.analyzer.searchAsync(filters);
    }

    public <T> Future<Boolean> findExistingAsync(JsonObject filters) {
        return this.findAsync(filters).compose(item -> Future.succeededFuture((Object)(0 < item.size() ? 1 : 0)));
    }

    public <T> Future<Boolean> findMissingAsync(JsonObject filters) {
        return this.findAsync(filters).compose(item -> Future.succeededFuture((Object)(0 == item.size() ? 1 : 0)));
    }

    public <T> List<T> find(JsonObject filters) {
        return this.analyzer.search(filters);
    }

    public <T> Boolean findExisting(JsonObject filters) {
        List<T> list = this.find(filters);
        return 0 < list.size();
    }

    public <T> Boolean findMissing(JsonObject filters) {
        List<T> list = this.find(filters);
        return 0 == list.size();
    }

    public Future<Integer> countAsync(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.analyzer.countAsync(inquiry, null);
    }

    public Future<Integer> countAsync(JsonObject params) {
        return this.countAsync(params, this.analyzer.getPojoFile());
    }

    public Integer count(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.analyzer.count(inquiry, null);
    }

    public Integer count(JsonObject params) {
        return this.count(params, this.analyzer.getPojoFile());
    }

    public Future<JsonObject> searchAsync(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.searchAsync(inquiry, pojo);
    }

    public Future<JsonObject> searchAsync(JsonObject params) {
        return this.searchAsync(params, this.analyzer.getPojoFile());
    }

    public Future<JsonObject> searchAsync(Inquiry inquiry, String pojo) {
        return this.analyzer.searchJObjectAsync(inquiry, pojo);
    }

    public JsonObject search(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.search(inquiry, pojo);
    }

    public JsonObject search(JsonObject params) {
        return this.search(params, this.analyzer.getPojoFile());
    }

    public JsonObject search(Inquiry inquiry, String pojo) {
        return this.analyzer.searchJObject(inquiry, pojo);
    }

    public Future<JsonObject> searchOrAsync(Inquiry inquiry) {
        return this.searchOrAsync(inquiry, "");
    }

    public Future<JsonObject> searchOrAsync(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.searchOrAsync(inquiry, pojo);
    }

    public Future<JsonObject> searchOrAsync(Inquiry inquiry, String pojo) {
        return this.analyzer.searchJObjectAsync(inquiry, pojo, Operator.OR);
    }

    public JsonObject searchOr(Inquiry inquiry) {
        return this.searchOr(inquiry, "");
    }

    public JsonObject searchOr(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.searchOr(inquiry, pojo);
    }

    public JsonObject searchOr(Inquiry inquiry, String pojo) {
        return this.analyzer.searchJObject(inquiry, pojo, Operator.OR);
    }

    public Future<JsonObject> searchAndAsync(Inquiry inquiry) {
        return this.searchAndAsync(inquiry, "");
    }

    public Future<JsonObject> searchAndAsync(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.searchAndAsync(inquiry, pojo);
    }

    public Future<JsonObject> searchAndAsync(Inquiry inquiry, String pojo) {
        return this.analyzer.searchJObjectAsync(inquiry, pojo, Operator.AND);
    }

    public JsonObject searchAnd(Inquiry inquiry) {
        return this.searchAnd(inquiry, "");
    }

    public JsonObject searchAnd(JsonObject params, String pojo) {
        Inquiry inquiry = Query.getInquiry(params, pojo);
        return this.searchAnd(inquiry, pojo);
    }

    public JsonObject searchAnd(Inquiry inquiry, String pojo) {
        return this.analyzer.searchJObject(inquiry, pojo, Operator.AND);
    }

    public <T> Future<List<T>> searchAndListAsync(Inquiry inquiry) {
        return this.analyzer.searchAsync(inquiry, Operator.AND);
    }

    public <T> Future<List<T>> searchOrListAsync(Inquiry inquiry) {
        return this.analyzer.searchAsync(inquiry, Operator.OR);
    }

    public <T> List<T> searchAndList(Inquiry inquiry) {
        return this.analyzer.search(inquiry, Operator.AND);
    }

    public <T> List<T> searchOrList(Inquiry inquiry) {
        return this.analyzer.search(inquiry, Operator.OR);
    }

    public <T> Future<List<T>> fetchAndAsync(JsonObject andFilters) {
        return this.reader.fetchAsync(JooqCond.transform(andFilters, Operator.AND, this.analyzer::getColumn));
    }

    public <T> List<T> fetchAnd(JsonObject andFilters) {
        return this.reader.fetch(JooqCond.transform(andFilters, Operator.AND, this.analyzer::getColumn));
    }

    public <T> Future<List<T>> fetchOrAsync(JsonObject orFilters) {
        return this.reader.fetchAsync(JooqCond.transform(orFilters, Operator.OR, this.analyzer::getColumn));
    }

    public <T> List<T> fetchOr(JsonObject orFilters) {
        return this.reader.fetch(JooqCond.transform(orFilters, Operator.OR, this.analyzer::getColumn));
    }

    public <T> Future<T> fetchOneAndAsync(JsonObject andFilters) {
        return this.reader.fetchOneAndAsync(andFilters);
    }

    public <T> T fetchOneAnd(JsonObject andFilters) {
        return this.reader.fetchOneAnd(andFilters);
    }

    public <T> Future<T> upsertAsync(JsonObject andFilters, T updated) {
        return this.fetchOneAndAsync(andFilters).compose(item -> Fn.match((Case.DefaultCase)Fn.fork(() -> this.updateAsync(this.analyzer.copyEntity(item, updated))), (Case[])new Case[]{Fn.branch((null == item ? 1 : 0) != 0, () -> this.insertAsync(updated))}));
    }

    public <T> T upsert(JsonObject andFilters, T updated) {
        T entity = this.fetchOneAnd(andFilters);
        if (null == entity) {
            return this.insert(updated);
        }
        return this.update(this.analyzer.copyEntity(entity, updated));
    }
}

