/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystemException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.KeyStoreOptions;
import io.vertx.ext.auth.PubSecKeyOptions;
import io.vertx.ext.auth.SecretOptions;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.jwt.JWK;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.jwt.JWTOptions;
import io.vertx.up.exception._500JwtRuntimeException;
import io.vertx.up.secure.provider.JwtAuthProvider;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroUniform;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

class UxJwt {
    private static JWT JWT_INSTANCE;

    UxJwt() {
    }

    static JsonObject extract(String jwt) {
        JsonObject config = UxJwt.readOptions();
        return (JsonObject)Fn.getNull(() -> UxJwt.extract(jwt, config), (Object[])new Object[]{config});
    }

    static String generate(JsonObject claims, JWTOptions options) {
        return UxJwt.generate(claims, options, Ut::ioBuffer);
    }

    static String generate(JsonObject claims, JWTOptions options, Function<String, Buffer> funcBuffer) {
        JsonObject opts = UxJwt.readOptions();
        JWTAuthOptions meta = (JWTAuthOptions)Fn.getNull((Object)new JWTAuthOptions(), () -> new JWTAuthOptions(opts), (Object[])new Object[]{opts});
        return (String)Fn.getNull(() -> {
            JsonObject _claims = claims.copy();
            if (options.getPermissions() != null && !_claims.containsKey(meta.getPermissionsClaimKey())) {
                _claims.put(meta.getPermissionsClaimKey(), new JsonArray(options.getPermissions()));
            }
            JWT reference = UxJwt.create(meta, funcBuffer);
            return reference.sign(_claims, options);
        }, (Object[])new Object[]{meta, claims});
    }

    private static JsonObject readOptions() {
        Node node = (Node)Ut.instance(ZeroUniform.class, (Object[])new Object[0]);
        JsonObject options = (JsonObject)node.read();
        JsonObject secure = (JsonObject)Fn.getNull(() -> options.getJsonObject("secure"), (Object[])new Object[]{options});
        JsonObject jwtConfig = (JsonObject)Fn.getNull(() -> secure.getJsonObject("jwt"), (Object[])new Object[]{secure});
        return (JsonObject)Fn.getNull(() -> jwtConfig.getJsonObject("config"), (Object[])new Object[]{jwtConfig});
    }

    static JsonObject extract(String jwt, JsonObject options) {
        JWT reference = UxJwt.create(new JWTAuthOptions(options), Ut::ioBuffer);
        return reference.decode(jwt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static JWT create(JWTAuthOptions config, Function<String, Buffer> funcBuffer) {
        if (null != JWT_INSTANCE) return JWT_INSTANCE;
        Class<UxJwt> clazz = UxJwt.class;
        synchronized (UxJwt.class) {
            if (null != JWT_INSTANCE) return JWT_INSTANCE;
            JWT_INSTANCE = UxJwt.createDirect(config, funcBuffer);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return JWT_INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JWT createDirect(JWTAuthOptions config, Function<String, Buffer> funcBuffer) {
        KeyStoreOptions keyStore = config.getKeyStore();
        try {
            List secrets;
            if (keyStore != null) {
                KeyStore ks = KeyStore.getInstance(keyStore.getType());
                Class<JwtAuthProvider> var5 = JwtAuthProvider.class;
                Class<JwtAuthProvider> clazz = JwtAuthProvider.class;
                synchronized (JwtAuthProvider.class) {
                    Buffer keystore = funcBuffer.apply(keyStore.getPath());
                    try (ByteArrayInputStream in = new ByteArrayInputStream(keystore.getBytes());){
                        ks.load(in, keyStore.getPassword().toCharArray());
                    }
                    // ** MonitorExit[var6_8] (shouldn't be in output)
                    return new JWT(ks, keyStore.getPassword().toCharArray());
                }
            }
            JWT reference = new JWT();
            List keys = config.getPubSecKeys();
            if (keys != null) {
                for (PubSecKeyOptions pubSecKey : config.getPubSecKeys()) {
                    if (pubSecKey.isSymmetric()) {
                        reference.addJWK(new JWK(pubSecKey.getAlgorithm(), pubSecKey.getPublicKey()));
                        continue;
                    }
                    reference.addJWK(new JWK(pubSecKey.getAlgorithm(), pubSecKey.isCertificate(), pubSecKey.getPublicKey(), pubSecKey.getSecretKey()));
                }
            }
            if ((secrets = config.getSecrets()) == null) return reference;
            Iterator var28 = secrets.iterator();
            while (var28.hasNext()) {
                SecretOptions secret = (SecretOptions)var28.next();
                reference.addSecret(secret.getType(), secret.getSecret());
            }
            return reference;
        }
        catch (FileSystemException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException var23) {
            throw new _500JwtRuntimeException(UxJwt.class, var23);
        }
    }
}

