/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.reactivex.Observable;
import io.vertx.core.Future;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.mongo.FindOptions;
import io.vertx.ext.mongo.MongoClient;
import io.vertx.ext.mongo.MongoClientDeleteResult;
import io.vertx.up.aiki.Ux;
import io.vertx.up.log.Annal;
import io.vertx.up.plugin.mongo.MongoInfix;
import java.util.Objects;
import java.util.function.BinaryOperator;

class UxMongo {
    private static final MongoClient CLIENT = MongoInfix.getClient();
    private static final Annal LOGGER = Annal.get(UxMongo.class);

    UxMongo() {
    }

    static Future<Boolean> missing(String collection, JsonObject filter) {
        return Ux.thenGeneric(future -> CLIENT.findOne(collection, filter, null, res -> {
            LOGGER.debug("[ ZERO ] ( Mongo -> findOne ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, res.result()});
            future.complete((Object)(null == res.result() ? 1 : 0));
        }));
    }

    static Future<Boolean> existing(String collection, JsonObject filter) {
        return Ux.thenGeneric(future -> CLIENT.findOne(collection, filter, null, res -> {
            LOGGER.debug("[ ZERO ] ( Mongo -> findOne ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, res.result()});
            future.complete((Object)(null != res.result() ? 1 : 0));
        }));
    }

    static JsonObject termIn(JsonObject filter, String field, JsonArray values) {
        JsonObject terms = new JsonObject();
        if (null != filter) {
            terms.mergeIn(filter);
        }
        return terms.put(field, new JsonObject().put("$in", values));
    }

    static JsonObject termLike(JsonObject filter, String field, String value) {
        JsonObject terms = new JsonObject();
        if (null != filter) {
            terms.mergeIn(filter);
        }
        return terms.put(field, new JsonObject().put("$regex", ".*" + value + ".*"));
    }

    static Future<JsonObject> insert(String collection, JsonObject data) {
        return Ux.thenGeneric(future -> CLIENT.insert(collection, data, res -> {
            if (res.succeeded()) {
                LOGGER.debug("[ ZERO ] ( Mongo -> insert ) collection = {0}, data = {1}.", new Object[]{collection, data});
                future.complete((Object)data);
            } else {
                LOGGER.debug("[ ZERO ] ( Mongo -> insert ) collection = {0}, data = {1}.", new Object[]{collection, null});
                future.complete();
            }
        }));
    }

    static Future<JsonObject> findOne(String collection, JsonObject filter) {
        return Ux.thenGeneric(future -> CLIENT.findOne(collection, filter, null, res -> {
            LOGGER.debug("[ ZERO ] ( Mongo -> findOne ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, res.result()});
            future.complete(res.result());
        }));
    }

    static Future<JsonObject> findOne(String collection, JsonObject filter, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
        JsonObject data = new JsonObject();
        return UxMongo.findOne(collection, filter).compose(result -> {
            data.mergeIn(result);
            JsonObject joinedFilter = null == additional ? new JsonObject() : additional.copy();
            joinedFilter.put(joinedKey, result.getValue("_id"));
            return UxMongo.findOne(joinedCollection, joinedFilter);
        }).compose(second -> Future.succeededFuture(operatorFun.apply(data, second)));
    }

    static Future<JsonObject> findOneAndReplace(String collection, JsonObject filter, JsonObject updated) {
        return Ux.thenGeneric(future -> CLIENT.findOne(collection, filter, null, handler -> {
            if (handler.succeeded()) {
                JsonObject data = ((JsonObject)handler.result()).mergeIn(updated);
                CLIENT.findOneAndReplace(collection, filter, data, result -> {
                    LOGGER.debug("[ ZERO ] ( Mongo -> findOneAndReplace ) collection = {0}, filter = {1}, result = {2}.", new Object[]{collection, filter, data});
                    future.complete((Object)data);
                });
            } else {
                future.complete((Object)updated);
            }
        }));
    }

    static Future<Long> removeDocument(String collection, JsonObject filter) {
        return Ux.thenGeneric(future -> CLIENT.removeDocument(collection, filter, res -> {
            Long removed = ((MongoClientDeleteResult)res.result()).getRemovedCount();
            LOGGER.debug("[ ZERO ] ( Mongo -> removeDocument ) Effected: {2} Rows. collection = {0}, filter = {1}.", new Object[]{collection, filter, removed});
            future.complete((Object)removed);
        }));
    }

    static Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options) {
        return Ux.thenGeneric(future -> CLIENT.findWithOptions(collection, filter, options, res -> {
            JsonArray result = new JsonArray();
            Observable.fromIterable((Iterable)((Iterable)res.result())).filter(Objects::nonNull).subscribe(arg_0 -> ((JsonArray)result).add(arg_0));
            LOGGER.debug("[ ZERO ] ( Mongo -> findWithOptions ) collection = {0}, filter = {1}, options = {2}, result = {3}.", new Object[]{collection, filter, options.toJson(), result});
            future.complete((Object)result);
        }));
    }

    static Future<JsonArray> findWithOptions(String collection, JsonObject filter, FindOptions options, String joinedCollection, String joinedKey, JsonObject additional, BinaryOperator<JsonObject> operatorFun) {
        return Ux.thenParallelArray(UxMongo.findWithOptions(collection, filter, options), item -> {
            JsonObject joinedFilter = null == additional ? new JsonObject() : additional.copy();
            joinedFilter.put(joinedKey, item.getValue("_id"));
            return UxMongo.findOne(joinedCollection, joinedFilter);
        }, operatorFun);
    }
}

