/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.aiki;

import io.vertx.core.Future;
import io.vertx.up.aiki.To;
import io.vertx.up.aiki.Ux;
import io.vertx.up.exception._500PoolInternalException;
import io.vertx.up.log.Annal;
import io.vertx.up.plugin.shared.MapInfix;
import io.vertx.up.plugin.shared.SharedClient;
import io.zero.epic.container.KeyPair;

public class UxPool {
    private static final Annal LOGGER = Annal.get(UxPool.class);
    private final transient String name;
    private final transient SharedClient client;

    UxPool() {
        this.name = MapInfix.getDefaultName();
        this.client = MapInfix.getClient();
    }

    UxPool(String name) {
        this.name = name;
        this.client = MapInfix.getClient().switchClient(name);
    }

    public <K, V> Future<KeyPair<K, V>> put(K key, V value) {
        return Ux.thenGeneric(future -> this.client.put(key, value, res -> {
            LOGGER.debug("[ ZERO ] ( Shared ) key = {0}, value = {1} has been put into {2}.", new Object[]{key, value, this.name});
            Ux.thenGeneric(res, future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "put"));
        }));
    }

    public <K, V> Future<KeyPair<K, V>> put(K key, V value, int expiredSecs) {
        return Ux.thenGeneric(future -> this.client.put(key, value, expiredSecs, res -> {
            LOGGER.debug("[ ZERO ] ( Shared ) key = {0}, value = {1} has been put into {2} to keep {3} seconds", new Object[]{key, value, this.name, String.valueOf(expiredSecs)});
            Ux.thenGeneric(res, future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "put"));
        }));
    }

    public <K, V> Future<KeyPair<K, V>> remove(K key) {
        return Ux.thenGeneric(future -> this.client.remove(key, res -> {
            LOGGER.debug("[ ZERO ] ( Shared ) key = {0} has been removed from pool name = {2}.", new Object[]{key, this.name});
            Ux.thenGeneric(res, future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "remove"));
        }));
    }

    public <K, V> Future<V> get(K key) {
        return Ux.thenGeneric(future -> this.client.get(key, res -> {
            LOGGER.debug("[ ZERO ] ( Shared ) key = {0} has been picked from {1}, mode = {2}", new Object[]{key, this.name, false});
            Ux.thenGeneric(res, future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "remove"));
        }));
    }

    public <K, V> Future<V> get(K key, boolean once) {
        return Ux.thenGeneric(future -> this.client.get(key, once, res -> {
            LOGGER.debug("[ ZERO ] ( Shared ) key = {0} has been picked from {1}, mode = {2}", new Object[]{key, this.name, once});
            Ux.thenGeneric(res, future, (Throwable)To.toError(_500PoolInternalException.class, this.getClass(), this.name, "remove"));
        }));
    }
}

