/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom;

import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.Session;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception._500InternalServerException;
import io.vertx.up.kidd.Readible;
import io.vertx.up.log.Annal;
import io.vertx.up.web.ZeroSerializer;
import io.vertx.zero.exception.IndexExceedException;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class Envelop
implements Serializable {
    private static final Annal LOGGER = Annal.get(Envelop.class);
    private final HttpStatusCode status;
    private final WebException error;
    private final JsonObject data;
    private final Map<String, Object> context = new HashMap<String, Object>();
    private MultiMap headers;
    private User user;
    private String uri;
    private HttpMethod method;
    private String key;
    private Session session;

    private <T> Envelop(T data, HttpStatusCode status) {
        Object serialized = ZeroSerializer.toSupport(data);
        JsonObject bodyData = new JsonObject();
        bodyData.put("data", serialized);
        this.data = bodyData;
        this.error = null;
        this.status = status;
    }

    private Envelop(WebException error) {
        this.status = error.getStatus();
        this.error = error;
        this.data = error.toJson();
    }

    public static Envelop ok() {
        return Envelop.success(null);
    }

    public static <T> Envelop success(T entity) {
        return new Envelop(entity, HttpStatusCode.OK);
    }

    public static Envelop failure(String message) {
        return new Envelop(new _500InternalServerException(Envelop.class, message));
    }

    public static <T> Envelop success(T entity, HttpStatusCode status) {
        return new Envelop(entity, status);
    }

    public static Envelop failure(WebException error) {
        Readible readible = Readible.get();
        readible.interpret(error);
        return new Envelop(error);
    }

    public boolean valid() {
        return null == this.error;
    }

    public <T> T data() {
        if (null != this.data && this.data.containsKey("data")) {
            Object value = this.data.getValue("data");
            if (null != value) {
                return (T)value;
            }
            return null;
        }
        return null;
    }

    public <T> T data(Class<T> clazz) {
        T reference = null;
        if (this.data.containsKey("data")) {
            reference = this.extract(this.data.getValue("data"), clazz);
        }
        return reference;
    }

    public <T> T context(String key, Class<T> clazz) {
        T reference = null;
        if (this.context.containsKey(key)) {
            reference = this.extract(this.context.get(key), clazz);
        }
        return reference;
    }

    public <T> T data(Integer argIndex, Class<T> clazz) {
        String key;
        JsonObject raw;
        T reference = null;
        Fn.outUp((0 > argIndex ? 1 : 0) != 0, (Annal)LOGGER, IndexExceedException.class, (Object[])new Object[]{this.getClass(), argIndex});
        if (this.data.containsKey("data") && null != (raw = this.data.getJsonObject("data")) && raw.containsKey(key = argIndex.toString())) {
            reference = this.extract(raw.getValue(key), clazz);
        }
        return reference;
    }

    private JsonObject getData(Integer argIndex) {
        JsonObject data = new JsonObject();
        Object reference = Fn.getNull(null, () -> this.data.getValue("data"), (Object[])new Object[]{this.data});
        if (reference instanceof JsonObject) {
            data = (JsonObject)reference;
        }
        if (null == argIndex) {
            JsonObject extracted = new JsonObject();
            for (int idx = 0; idx < 10; ++idx) {
                String key = String.valueOf(idx);
                Object value = data.getValue(key);
                if (!(value instanceof JsonObject)) continue;
                extracted.mergeIn((JsonObject)value);
                break;
            }
            if (!Ut.isNil((JsonObject)extracted)) {
                data = extracted;
            }
        } else {
            data = data.getJsonObject(String.valueOf(argIndex));
        }
        return data;
    }

    public void setValue(String field, Object value) {
        this.setValue(null, field, value);
    }

    public void setValue(Integer argIndex, String field, Object value) {
        JsonObject reference = this.getData(argIndex);
        if (null != reference) {
            reference.put(field, value);
        }
    }

    private <T> T extract(Object value, Class<T> clazz) {
        Object reference = null;
        if (null != value) {
            Object result = ZeroSerializer.getValue(clazz, value.toString());
            reference = Fn.getNull(() -> result, (Object[])new Object[]{result});
        }
        return (T)reference;
    }

    public String responseString() {
        return this.responseJson().encode();
    }

    public JsonObject responseJson() {
        JsonObject response = null == this.error ? this.data : this.error.toJson();
        return response;
    }

    public Buffer responseBuffer() {
        Buffer buffer = Buffer.buffer();
        if (null == this.error) {
            JsonObject response = this.data.getJsonObject("data");
            buffer = Buffer.buffer((byte[])response.getBinary("bytes"));
        } else {
            JsonObject error = this.error.toJson();
            buffer = Buffer.buffer((String)error.encode());
        }
        return buffer;
    }

    public Future<Envelop> toFuture() {
        return Future.succeededFuture((Object)this);
    }

    public HttpStatusCode status() {
        return this.status;
    }

    public User user() {
        return this.user;
    }

    public MultiMap headers() {
        return this.headers;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setHeaders(MultiMap headers) {
        this.headers = headers;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public Map<String, Object> context() {
        return this.context;
    }

    public void setContext(Map<String, Object> data) {
        this.context.putAll(data);
    }

    public Envelop key(String key) {
        this.key = key;
        return this;
    }

    public String key() {
        return this.key;
    }

    public String identifier(String field) {
        return (String)Fn.getJvm((Object)"", () -> {
            JsonObject credential = this.user.principal();
            return (String)Fn.getSemi((null != credential && credential.containsKey(field) ? 1 : 0) != 0, () -> credential.getString(field), () -> "");
        }, (Object[])new Object[]{this.user});
    }

    public String toString() {
        return "Envelop{status=" + this.status + ", \nheaders=\n[" + this.headers + "], \nerror=" + this.error + ", \ndata=" + this.data + ", \nuser=" + this.user + ", \nuri=" + this.uri + '}';
    }
}

