/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.boot;

import io.vertx.core.ClusterOptions;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EnvelopCodec;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.up.atom.Envelop;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.log.Annal;
import io.vertx.up.web.ZeroAnno;
import io.vertx.up.web.ZeroGrid;
import io.vertx.up.web.ZeroHelper;
import io.vertx.zero.exception.VertxCallbackException;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class Motor {
    private static final Annal LOGGER = Annal.get(Motor.class);

    public static <T> void start(Class<?> clazz, Consumer<T> consumer, Consumer<Consumer<T>> fnSingle, BiConsumer<ClusterManager, Consumer<T>> fnCluster, Annal logger) {
        if (null == consumer) {
            throw new VertxCallbackException(clazz);
        }
        ClusterOptions cluster = ZeroGrid.getClusterOption();
        if (cluster.isEnabled()) {
            ClusterManager manager = cluster.getManager();
            logger.info("[ ZERO ] Current app is running in cluster mode, manager = {0} on node {1} with status = {2}.", new Object[]{manager.getClass().getName(), manager.getNodeID(), manager.isActive()});
            fnCluster.accept(manager, consumer);
        } else {
            fnSingle.accept(consumer);
        }
    }

    public static void each(BiConsumer<String, VertxOptions> consumer) {
        ConcurrentMap<String, VertxOptions> vertxOptions = ZeroGrid.getVertxOptions();
        vertxOptions.forEach(consumer);
    }

    public static void codec(EventBus eventBus) {
        eventBus.registerDefaultCodec(Envelop.class, (MessageCodec)Ut.singleton(EnvelopCodec.class, (Object[])new Object[0]));
    }

    public static ConcurrentMap<ServerType, Class<?>> agents(ServerType category, Class<?>[] defaultAgents, ConcurrentMap<ServerType, Class<?>> internals) {
        ConcurrentMap<ServerType, List<Class<?>>> agents = Motor.getMergedAgents(category, internals);
        ConcurrentMap<ServerType, Boolean> defines = ZeroHelper.isAgentDefined(agents, defaultAgents);
        ConcurrentHashMap ret = new ConcurrentHashMap();
        Ut.itMap(agents, (type, list) -> Fn.safeSemi((defines.containsKey(type) && (Boolean)defines.get(type) != false ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Class found = (Class)Ut.elementFind((List)list, item -> internals.get(type) != item);
            if (null != found) {
                ret.put((ServerType)type, found);
            }
        }, () -> {
            Class found = (Class)Ut.elementFind((List)list, item -> internals.get(type) == item);
            if (null != found) {
                LOGGER.info("[ ZERO ] User defined agent {0} of type = {1}, the default will be overwritten.", new Object[]{found, type});
                ret.put((ServerType)type, found);
            }
        }));
        return Motor.filterAgents(ret);
    }

    private static ConcurrentMap<ServerType, Class<?>> filterAgents(ConcurrentMap<ServerType, Class<?>> agents) {
        if (ZeroGrid.getRpcOptions().isEmpty()) {
            agents.remove(ServerType.IPC);
        } else {
            LOGGER.info("[ ZERO ] ( Micro -> Rpc ) Zero system detected the rpc server is Enabled. ", new Object[0]);
        }
        if (ZeroGrid.getSockOptions().isEmpty()) {
            agents.remove(ServerType.SOCK);
        } else {
            LOGGER.info("[ ZERO ] ( Micro -> Sock ) Zero system detected the socket server is Enabled.", new Object[0]);
        }
        return agents;
    }

    private static ConcurrentMap<ServerType, List<Class<?>>> getMergedAgents(ServerType category, ConcurrentMap<ServerType, Class<?>> internals) {
        ConcurrentMap<ServerType, List<Class<?>>> agents = ZeroAnno.getAgents();
        if (agents.isEmpty()) {
            agents.put(category, new ArrayList(internals.values()));
        }
        return agents;
    }
}

