/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.media.parse;

import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.atom.agent.Event;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.up.media.parse.Atomic;
import io.vertx.up.media.parse.Income;
import io.vertx.up.media.parse.MimeAtomic;
import io.vertx.up.rs.Filler;
import io.vertx.up.web.ZeroSerializer;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.DefaultValue;

public class EpsilonIncome
implements Income<List<Epsilon<Object>>> {
    private static final Annal LOGGER = Annal.get(EpsilonIncome.class);
    private final transient Atomic<Object> atomic = (Atomic)Ut.singleton(MimeAtomic.class, (Object[])new Object[0]);

    @Override
    public List<Epsilon<Object>> in(RoutingContext context, Event event) throws WebException {
        Method method = event.getAction();
        Class<?>[] paramTypes = method.getParameterTypes();
        Annotation[][] annoTypes = method.getParameterAnnotations();
        ArrayList<Epsilon<Object>> args = new ArrayList<Epsilon<Object>>();
        for (int idx = 0; idx < paramTypes.length; ++idx) {
            Epsilon epsilon = new Epsilon();
            epsilon.setArgType(paramTypes[idx]);
            epsilon.setAnnotation(this.getAnnotation(annoTypes[idx]));
            epsilon.setName(this.getName(epsilon.getAnnotation()));
            epsilon.setDefaultValue(this.getDefault(annoTypes[idx], epsilon.getArgType()));
            Epsilon<Object> outcome = this.atomic.ingest(context, epsilon);
            args.add((Epsilon<Object>)Fn.getNull(() -> outcome, (Object[])new Object[]{outcome}));
        }
        return args;
    }

    private String getName(Annotation annotation) {
        return (String)Fn.getSemi((null == annotation ? 1 : 0) != 0, (Annal)LOGGER, () -> "$$IGNORE$$", () -> (String)Fn.getSemi((!Filler.NO_VALUE.contains(annotation.annotationType()) ? 1 : 0) != 0, (Annal)LOGGER, () -> (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]), () -> "$$DIRECT$$"));
    }

    private Annotation getAnnotation(Annotation[] annotations) {
        List annotationList = Arrays.stream(annotations).filter(item -> Filler.PARAMS.containsKey(item.annotationType())).collect(Collectors.toList());
        return annotationList.isEmpty() ? null : (Annotation)annotationList.get(0);
    }

    private Object getDefault(Annotation[] annotations, Class<?> paramType) {
        List annotationList = Arrays.stream(annotations).filter(item -> item.annotationType() == DefaultValue.class).collect(Collectors.toList());
        return Fn.getSemi((boolean)annotationList.isEmpty(), (Annal)LOGGER, Fn::nil, () -> {
            Annotation annotation = (Annotation)annotationList.get(0);
            return ZeroSerializer.getValue(paramType, (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]));
        });
    }
}

