/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.media.parse;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.eon.em.MimeFlow;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.up.media.Resolver;
import io.vertx.up.media.parse.Atomic;
import io.vertx.up.media.parse.StandardAtomic;
import io.vertx.up.media.parse.TypedAtomic;
import io.vertx.up.media.resolver.UnsetResolver;
import io.vertx.zero.marshal.node.Node;
import io.zero.epic.Ut;
import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;

public class MimeAtomic<T>
implements Atomic<T> {
    private static final Node<JsonObject> NODE = Node.infix((String)"resolver");
    private static final Annal LOGGER = Annal.get(MimeAtomic.class);

    @Override
    public Epsilon<T> ingest(RoutingContext context, Epsilon<T> income) throws WebException {
        Epsilon<T> epsilon;
        if (MimeFlow.TYPED == income.getMime()) {
            Atomic atomic = (Atomic)Ut.singleton(TypedAtomic.class, (Object[])new Object[0]);
            epsilon = atomic.ingest(context, income);
        } else if (MimeFlow.STANDARD == income.getMime()) {
            Atomic atomic = (Atomic)Ut.singleton(StandardAtomic.class, (Object[])new Object[0]);
            epsilon = atomic.ingest(context, income);
        } else {
            Resolver<T> resolver = this.getResolver(context, income);
            epsilon = resolver.resolve(context, income);
        }
        return epsilon;
    }

    private Resolver<T> getResolver(RoutingContext context, Epsilon<T> income) {
        Annotation annotation = income.getAnnotation();
        Class resolverCls = (Class)Ut.invoke((Object)annotation, (String)"resolver", (Object[])new Object[0]);
        String header = context.request().getHeader("Content-Type");
        if (UnsetResolver.class == resolverCls) {
            String resolver;
            JsonObject content = (JsonObject)NODE.read();
            if (null == header) {
                resolver = content.getString("default");
            } else {
                MediaType type = MediaType.valueOf((String)header);
                JsonObject resolverMap = content.getJsonObject(type.getType());
                resolver = resolverMap.getString(type.getSubtype());
            }
            LOGGER.info("[ ZERO ] ( Resolver ) Select resolver {0} for Content-Type {1} when request to {2}", new Object[]{resolver, header, context.request().absoluteURI()});
            return (Resolver)Ut.singleton((String)resolver, (Object[])new Object[0]);
        }
        LOGGER.info("[ ZERO ] ( Resolver ) Select resolver from annotation config \"{0}\" for Content-Type {1}", new Object[]{resolverCls, header});
        return (Resolver)Ut.singleton((Class)resolverCls, (Object[])new Object[0]);
    }
}

