/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.media.resolver;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.log.Annal;
import io.vertx.up.media.Resolver;
import io.vertx.up.web.ZeroSerializer;
import java.io.File;
import java.util.Set;

public class FileResolver<T>
implements Resolver<T> {
    private static final Annal LOGGER = Annal.get(FileResolver.class);

    @Override
    public Epsilon<T> resolve(RoutingContext context, Epsilon<T> income) {
        context.request().headers().forEach(item -> LOGGER.info("[ ZERO ] Headers: {0} = {1}", new Object[]{item.getKey(), item.getValue()}));
        Set fileUploads = context.fileUploads();
        LOGGER.info("[ ZERO ] Upload files: size = {0}", new Object[]{fileUploads.size()});
        if (1 == fileUploads.size()) {
            FileUpload fileUpload = (FileUpload)fileUploads.iterator().next();
            if (income.getArgType().isAssignableFrom(FileUpload.class)) {
                income.setValue(fileUpload);
            } else if (income.getArgType() == File.class) {
                Object ret = ZeroSerializer.getValue(income.getArgType(), fileUpload.uploadedFileName());
                income.setValue((FileUpload)ret);
            } else if (income.getArgType().isArray()) {
                if (Byte.TYPE == income.getArgType().getComponentType() || Byte.class == income.getArgType().getComponentType()) {
                    FileSystem fileSystem = context.vertx().fileSystem();
                    Buffer buffer = fileSystem.readFileBlocking(fileUpload.uploadedFileName());
                    income.setValue((FileUpload)buffer.getBytes());
                }
            } else if (Buffer.class.isAssignableFrom(income.getArgType())) {
                FileSystem fileSystem = context.vertx().fileSystem();
                Buffer buffer = fileSystem.readFileBlocking(fileUpload.uploadedFileName());
                income.setValue((FileUpload)buffer);
            }
        } else {
            income.setValue((FileUpload)fileUploads);
        }
        return income;
    }
}

