/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.up.annotations.Agent;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.Pool;
import io.vertx.up.micro.ZeroAtomic;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.router.PointAxis;
import io.vertx.up.rs.router.RouterAxis;
import io.vertx.up.rs.router.WallAxis;
import io.vertx.zero.config.ServerVisitor;
import io.vertx.zero.micro.config.DynamicVisitor;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@Agent(type=ServerType.API)
public class ZeroApiAgent
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroApiAgent.class);
    private static final ServerVisitor<HttpServerOptions> VISITOR = (ServerVisitor)Ut.singleton(DynamicVisitor.class, (Object[])new Object[0]);
    private static final ConcurrentMap<Integer, AtomicInteger> API_START_LOGS = new ConcurrentHashMap<Integer, AtomicInteger>();

    public void start() {
        Axis routerAxiser = (Axis)Fn.poolThread(Pool.ROUTERS, () -> (Axis)Ut.instance(RouterAxis.class, (Object[])new Object[0]));
        Axis wallAxiser = (Axis)Fn.poolThread(Pool.WALLS, () -> (Axis)Ut.instance(WallAxis.class, (Object[])new Object[]{this.vertx}));
        Fn.outUp(() -> ZeroAtomic.API_OPTS.forEach((port, option) -> {
            Axis axiser = (Axis)Fn.poolThread(Pool.APIS, () -> (Axis)Ut.instance(PointAxis.class, (Object[])new Object[]{option, this.vertx}));
            HttpServer server = this.vertx.createHttpServer(option);
            Router router = Router.router((Vertx)this.vertx);
            routerAxiser.mount(router);
            wallAxiser.mount(router);
            axiser.mount(router);
            server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen();
            this.registryServer((HttpServerOptions)option);
        }), (Annal)LOGGER);
    }

    private void registryServer(HttpServerOptions options) {
        Integer port = options.getPort();
        AtomicInteger out = (AtomicInteger)API_START_LOGS.get(port);
        if (0 == out.getAndIncrement()) {
            String portLiteral = String.valueOf(port);
            LOGGER.info("[ ZERO ] ( Api Gateway ) {0} (id = {1}) has deployed on {2}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this.deploymentID(), portLiteral});
            String address = MessageFormat.format("http://{0}:{1}/", options.getHost(), portLiteral);
            LOGGER.info("[ ZERO ] ( Api Gateway ) {0} has been started successfully. Endpoint: {1}.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), address});
        }
    }

    static {
        Fn.outUp(() -> {
            if (ZeroAtomic.API_OPTS.isEmpty()) {
                ZeroAtomic.API_OPTS.putAll((Map)VISITOR.visit(new String[]{ServerType.API.toString()}));
                ZeroAtomic.API_OPTS.forEach((port, option) -> API_START_LOGS.put((Integer)port, new AtomicInteger(0)));
            }
        }, (Annal)LOGGER);
    }
}

