/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Worker;
import io.vertx.up.eon.em.Etat;
import io.vertx.up.eon.em.MessageModel;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.center.ZeroRegistry;
import java.util.Arrays;
import java.util.TreeSet;

@Worker(value=MessageModel.REQUEST_MICRO_WORKER, instances=1)
public class ZeroHttpRegistry
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroHttpRegistry.class);
    private final transient ZeroRegistry registry = ZeroRegistry.create(((Object)((Object)this)).getClass());

    public void start() {
        EventBus bus = this.vertx.eventBus();
        bus.consumer("ZERO://MICRO/REGISTRY/START", result -> {
            JsonObject data = (JsonObject)result.body();
            String name = data.getString("name");
            HttpServerOptions options = new HttpServerOptions(data.getJsonObject("options"));
            String[] uris = data.getString("uris").split(",");
            TreeSet<String> uriData = new TreeSet<String>(Arrays.asList(uris));
            this.registry.registryHttp(name, options, Etat.RUNNING);
            this.registry.registryRoute(name, options, uriData);
            LOGGER.info("[ ZERO ] {2} <--- ( Micro Worker ) {0} ( name = {1} ) getNull data from internal address.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), name, "ZERO://MICRO/REGISTRY/START"});
        });
    }
}

