/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.ServidorOptions;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.grpc.VertxServer;
import io.vertx.grpc.VertxServerBuilder;
import io.vertx.up.annotations.Agent;
import io.vertx.up.eon.em.Etat;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ZeroAtomic;
import io.vertx.up.micro.center.ZeroRegistry;
import io.vertx.up.micro.ipc.server.Tunnel;
import io.vertx.up.micro.ipc.server.UnityTunnel;
import io.zero.epic.Ut;
import java.util.concurrent.atomic.AtomicInteger;

@Agent(type=ServerType.IPC)
public class ZeroRpcAgent
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroRpcAgent.class);
    private static final String SSL = "ssl";
    private final transient ZeroRegistry registry = ZeroRegistry.create(((Object)((Object)this)).getClass());

    public void start() {
        Ut.itMap(ZeroAtomic.RPC_OPTS, (port, config) -> {
            VertxServerBuilder builder = VertxServerBuilder.forAddress((Vertx)this.vertx, (String)config.getHost(), (int)config.getPort());
            Tunnel tunnel = (Tunnel)Ut.singleton(UnityTunnel.class, (Object[])new Object[0]);
            builder.addService(tunnel.init(this.vertx));
            VertxServer server = builder.build();
            server.start(handler -> this.registryServer((AsyncResult<Void>)handler, (ServidorOptions)config));
        });
    }

    public void stop() {
        Ut.itMap(ZeroAtomic.RPC_OPTS, (port, config) -> this.registry.registryRpc((ServidorOptions)config, Etat.STOPPED));
    }

    private void registryServer(AsyncResult<Void> handler, ServidorOptions options) {
        Integer port = options.getPort();
        AtomicInteger out = (AtomicInteger)ZeroAtomic.RPC_START_LOGS.get(port);
        if (1 == out.getAndIncrement()) {
            if (handler.succeeded()) {
                LOGGER.info("[ ZERO ] ( Rpc Server ) Rpc Server has been started successfully. Channel: ---> grpc://{0}:{1}. ", new Object[]{Ut.netIPv4(), String.valueOf(options.getPort())});
                LOGGER.info("[ ZERO ] ( Etcd Center ) Zero system detected configuration {0}, start to initialize Etcd Center.", new Object[]{this.registry.getConfig()});
                this.startRegistry(options);
            } else {
                LOGGER.info("[ ZERO ] ( Rpc Server ) Rpc Server met failure: details = {0}.", new Object[]{null == handler.cause() ? "None" : handler.cause().getMessage()});
            }
        }
    }

    private void startRegistry(ServidorOptions options) {
        EventBus bus = this.vertx.eventBus();
        String address = "ZERO://MICRO/IPC/START";
        LOGGER.info("[ ZERO ] ---> {2} ( Rpc Server ) {0} ( name = {1} ) is sending data to internal address.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), options.getName(), "ZERO://MICRO/IPC/START"});
        bus.publish("ZERO://MICRO/IPC/START", (Object)options.toJson());
    }
}

