/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.ServidorOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonObject;
import io.vertx.up.annotations.Worker;
import io.vertx.up.eon.em.Etat;
import io.vertx.up.eon.em.MessageModel;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.center.ZeroRegistry;
import io.vertx.up.micro.ipc.server.Tunnel;

@Worker(value=MessageModel.REQUEST_MICRO_WORKER, instances=1)
public class ZeroRpcRegistry
extends AbstractVerticle {
    private final transient ZeroRegistry registry = ZeroRegistry.create(((Object)((Object)this)).getClass());
    private static final Annal LOGGER = Annal.get(ZeroRpcRegistry.class);

    public void start() {
        EventBus bus = this.vertx.eventBus();
        bus.consumer("ZERO://MICRO/IPC/START", result -> {
            JsonObject data = (JsonObject)result.body();
            ServidorOptions options = new ServidorOptions(data);
            this.registry.registryRpc(options, Etat.RUNNING);
            this.registry.registryIpcs(options, Tunnel.IPCS.keySet());
            LOGGER.info("[ ZERO ] {2} <--- ( Micro Worker ) {0} ( name = {1} ) getNull data from internal address.", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), options.getName(), "ZERO://MICRO/IPC/START"});
        });
    }
}

