/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.discovery;

import io.vertx.servicediscovery.Record;
import io.vertx.up.micro.discovery.ApiOrigin;
import io.vertx.up.micro.discovery.IpcOrigin;
import io.vertx.up.micro.discovery.Origin;
import io.vertx.up.web.Runner;
import io.zero.epic.Ut;
import java.util.concurrent.ConcurrentMap;

public class EtcdEraser {
    private static EtcdEraser INSTANCE;

    public static EtcdEraser create() {
        if (null == INSTANCE) {
            INSTANCE = new EtcdEraser();
        }
        return INSTANCE;
    }

    public void start() {
        Runner.run(this::eraseApi, (String)"endpoint-eraser");
        Runner.run(this::eraseIpc, (String)"ipc-eraser");
    }

    private void eraseApi() {
        Origin origin = (Origin)Ut.singleton(ApiOrigin.class, (Object[])new Object[0]);
        ConcurrentMap<String, Record> records = origin.getRegistryData();
        records.forEach((key, value) -> origin.erasing((Record)value));
    }

    private void eraseIpc() {
        Origin origin = (Origin)Ut.singleton(IpcOrigin.class, (Object[])new Object[0]);
        ConcurrentMap<String, Record> records = origin.getRegistryData();
        records.forEach((key, value) -> origin.erasing((Record)value));
    }
}

