/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.discovery;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.servicediscovery.Record;
import io.vertx.up.atom.Envelop;
import io.vertx.up.exception._404ServiceNotFoundException;
import io.vertx.up.exception._405MethodForbiddenException;
import io.vertx.up.exception._500InternalServerException;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.hunt.Answer;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.io.InputStream;
import java.util.function.Consumer;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

public final class InOut {
    private static final Annal LOGGER = Annal.get(InOut.class);

    static void sync404Error(Class<?> clazz, RoutingContext context) {
        HttpServerRequest request = context.request();
        _404ServiceNotFoundException exception = new _404ServiceNotFoundException(clazz, request.uri(), request.method());
        Answer.reply(context, Envelop.failure(exception));
    }

    public static void sync405Error(Class<?> clazz, RoutingContext context) {
        HttpServerRequest request = context.request();
        _405MethodForbiddenException exception = new _405MethodForbiddenException(clazz, request.method(), request.uri());
        Answer.reply(context, Envelop.failure(exception));
    }

    public static void sync500Error(Class<?> clazz, RoutingContext context, Throwable ex) {
        _500InternalServerException exception = new _500InternalServerException(clazz, null == ex ? "Server Error" : ex.getMessage());
        Answer.reply(context, Envelop.failure(exception));
    }

    private static void syncSuccess(HttpServerResponse response, io.vertx.ext.web.client.HttpResponse<Buffer> clientResponse) {
        Buffer data = clientResponse.bodyAsBuffer();
        InOut.syncSuccess(response, clientResponse.headers(), clientResponse.statusCode(), clientResponse.statusMessage(), data);
    }

    static Handler<AsyncResult<io.vertx.ext.web.client.HttpResponse<Buffer>>> replyWeb(Class<?> clazz, RoutingContext context, Consumer<Void> consumer) {
        return response -> {
            if (response.succeeded()) {
                io.vertx.ext.web.client.HttpResponse remoteResp = (io.vertx.ext.web.client.HttpResponse)response.result();
                if (404 == remoteResp.statusCode()) {
                    InOut.sync405Error(clazz, context);
                } else {
                    InOut.syncSuccess(context.response(), (io.vertx.ext.web.client.HttpResponse<Buffer>)remoteResp);
                }
            } else {
                InOut.sync500Error(clazz, context, response.cause());
            }
            consumer.accept(null);
        };
    }

    static Handler<HttpResponse> replyHttp(Class<?> clazz, RoutingContext context, Consumer<Void> consumer) {
        return response -> {
            StatusLine line = response.getStatusLine();
            if (null == line) {
                InOut.sync500Error(clazz, context, new RuntimeException("Remote 500 Error."));
            } else if (404 == line.getStatusCode()) {
                InOut.sync405Error(clazz, context);
            } else {
                InOut.syncSuccess(context, response);
            }
            consumer.accept(null);
        };
    }

    private static void syncSuccess(RoutingContext context, HttpResponse clientResponse) {
        StatusLine line = clientResponse.getStatusLine();
        HttpServerResponse response = context.response();
        Fn.safeJvm(() -> {
            byte[] bytes;
            InputStream in = clientResponse.getEntity().getContent();
            int result = in.read(bytes = new byte[in.available()]);
            if (-1 != result) {
                Buffer buffer = Buffer.buffer((byte[])bytes);
                MultiMap headers = MultiMap.caseInsensitiveMultiMap();
                for (Header header : clientResponse.getAllHeaders()) {
                    LOGGER.info("[ Zero ] Response header: {0} = {1}", new Object[]{header.getName(), header.getValue()});
                    headers.set(header.getName(), header.getValue());
                }
                HttpServerRequest request = context.request();
                String origin = request.getHeader(HttpHeaders.ORIGIN);
                if (Ut.notNil((String)origin)) {
                    headers.set(HttpHeaders.ACCESS_CONTROL_ALLOW_ORIGIN, (CharSequence)origin);
                }
                InOut.syncSuccess(response, headers, line.getStatusCode(), line.getReasonPhrase(), buffer);
            }
        });
    }

    private static void syncSuccess(HttpServerResponse response, MultiMap headers, int statusCode, String statusMessage, Buffer data) {
        response.headers().setAll(headers);
        response.setStatusCode(statusCode);
        response.setStatusMessage(statusMessage);
        response.write(data);
        response.end();
    }

    public static String normalizeUri(RoutingContext event) {
        StringBuilder uri = new StringBuilder();
        uri.append(event.request().path());
        if (null != event.request().query()) {
            uri.append("?").append(event.request().query());
        }
        return uri.toString();
    }

    static RequestOptions getOptions(Record record, String normalizedUri) {
        RequestOptions options = new RequestOptions();
        options.setURI(normalizedUri);
        JsonObject location = record.getLocation();
        options.setHost(location.getString("host"));
        options.setPort(location.getInteger("port").intValue());
        LOGGER.info("[ ZERO ] Found remote host: {0}, port: {1}, uri: {2}", new Object[]{options.getHost(), String.valueOf(options.getPort()), options.getURI()});
        return options;
    }
}

