/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.discovery;

import io.vertx.circuitbreaker.CircuitBreaker;
import io.vertx.circuitbreaker.CircuitBreakerOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import io.vertx.servicediscovery.Record;
import io.vertx.servicediscovery.ServiceDiscovery;
import io.vertx.servicediscovery.ServiceReference;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.discovery.InOut;
import io.vertx.up.micro.discovery.multipart.UploadPipe;
import io.vertx.up.micro.matcher.Arithmetic;
import io.vertx.up.micro.matcher.CommonArithmetic;
import io.vertx.zero.marshal.Visitor;
import io.vertx.zero.micro.config.CircuitVisitor;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.List;
import java.util.function.Consumer;

public class ServiceJet {
    private static final Annal LOGGER = Annal.get(ServiceJet.class);
    private static final Visitor<CircuitBreakerOptions> VISITOR = (Visitor)Ut.singleton(CircuitVisitor.class, (Object[])new Object[0]);
    private static CircuitBreakerOptions OPTIONS;
    private final transient Arithmetic arithmetic = (Arithmetic)Ut.singleton(CommonArithmetic.class, (Object[])new Object[0]);
    private final transient HttpServerOptions options;
    private transient ServiceDiscovery discovery;
    private transient CircuitBreaker breaker;

    private ServiceJet(HttpServerOptions options) {
        this.options = options;
    }

    public static ServiceJet create(HttpServerOptions options) {
        return new ServiceJet(options);
    }

    public ServiceJet connect(Vertx vertx) {
        this.discovery = ServiceDiscovery.create((Vertx)vertx);
        String name = this.options.getHost() + this.options.getPort();
        this.breaker = CircuitBreaker.create((String)name, (Vertx)vertx, (CircuitBreakerOptions)OPTIONS);
        return this;
    }

    private Future<List<Record>> getEndPoints() {
        Future future = Future.future();
        this.discovery.getRecords(record -> record.getType().equals("http-endpoint"), future.completer());
        return future;
    }

    public Handler<RoutingContext> handle() {
        return context -> this.breaker.execute(future -> this.getEndPoints().setHandler(res -> {
            if (res.succeeded()) {
                List records = (List)res.result();
                Record hitted = this.arithmetic.search(records, (RoutingContext)context);
                if (null == hitted) {
                    InOut.sync404Error(this.getClass(), context);
                    future.complete();
                } else {
                    ServiceReference reference = this.discovery.getReference(hitted);
                    Consumer<Void> consumer = nil -> {
                        reference.release();
                        future.complete();
                    };
                    this.doRequest((RoutingContext)context, reference, hitted, consumer);
                }
            } else {
                future.fail(res.cause());
            }
        }));
    }

    private void doRequest(RoutingContext context, ServiceReference reference, Record record, Consumer<Void> consumer) {
        HttpServerRequest rctRequest = context.request();
        HttpMethod method = rctRequest.method();
        String uri = InOut.normalizeUri(context);
        WebClient client = (WebClient)reference.getAs(WebClient.class);
        RequestOptions options = InOut.getOptions(record, uri);
        HttpRequest request = client.request(method, options);
        MultiMap headers = rctRequest.headers();
        headers.forEach(item -> request.putHeader((String)item.getKey(), (String)item.getValue()));
        request.timeout(30000L);
        if (rctRequest.isExpectMultipart()) {
            UploadPipe pump = UploadPipe.create(context, reference, options);
            pump.doRequest(InOut.replyHttp(this.getClass(), context, consumer));
        } else {
            Buffer body = context.getBody();
            if (null == body) {
                body = Buffer.buffer();
            }
            request.sendBuffer(body, InOut.replyWeb(this.getClass(), context, consumer));
        }
    }

    static {
        Fn.outUp(() -> {
            if (null == OPTIONS) {
                OPTIONS = (CircuitBreakerOptions)VISITOR.visit(new String[0]);
            }
        }, (Annal)LOGGER);
    }
}

