/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.follow;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.up.aiki.Ux;
import io.vertx.up.atom.Envelop;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.follow.Invoker;
import io.vertx.up.micro.ipc.client.TunnelClient;
import io.vertx.up.web.ZeroSerializer;
import io.zero.epic.Ut;
import java.lang.reflect.Method;
import java.util.function.Function;

public abstract class AbstractInvoker
implements Invoker {
    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }

    protected Future invokeJson(Object proxy, Method method, Envelop envelop) {
        Object reference = envelop.data();
        Class<?> argType = method.getParameterTypes()[0];
        Object arguments = Ut.deserialize((String)Ut.toString(reference), argType);
        return (Future)Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{arguments});
    }

    protected Object invokeInternal(Object proxy, Method method, Envelop envelop) {
        Class<?> firstArg;
        Class<?>[] argTypes = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        Object returnValue = 1 == method.getParameterCount() ? (Envelop.class == (firstArg = argTypes[0]) ? Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{envelop}) : this.invokeSingle(proxy, method, envelop)) : this.invokeMulti(proxy, method, envelop);
        return returnValue;
    }

    private Object invokeMulti(Object proxy, Method method, Envelop envelop) {
        Object reference = envelop.data();
        Object[] arguments = new Object[method.getParameterCount()];
        JsonObject json = (JsonObject)reference;
        Class<?>[] types = method.getParameterTypes();
        for (int idx = 0; idx < types.length; ++idx) {
            Object argument;
            Object value = json.getValue(String.valueOf(idx));
            Class<?> type = types[idx];
            arguments[idx] = argument = null == value ? null : ZeroSerializer.getValue(type, value.toString());
        }
        return Ut.invoke((Object)proxy, (String)method.getName(), (Object[])arguments);
    }

    private Object invokeSingle(Object proxy, Method method, Envelop envelop) {
        JsonObject json;
        Object reference;
        Class<?> argType = method.getParameterTypes()[0];
        Object parameters = reference = envelop.data();
        if (JsonObject.class == reference.getClass() && this.isInterface(json = (JsonObject)reference) && 1 == json.fieldNames().size()) {
            parameters = json.getValue("0");
        }
        Object arguments = ZeroSerializer.getValue(argType, Ut.toString(parameters));
        return Ut.invoke((Object)proxy, (String)method.getName(), (Object[])new Object[]{arguments});
    }

    private boolean isInterface(JsonObject json) {
        long count = json.fieldNames().stream().filter(Ut::isInteger).count();
        this.getLogger().info("[ ZERO ] ( isInterface Mode ) Parameter count: {0}, json: {1}", new Object[]{count, json.encode()});
        return count == (long)json.fieldNames().size();
    }

    protected <I> Function<I, Future<Envelop>> nextEnvelop(Vertx vertx, Method method) {
        return item -> this.nextEnvelop(vertx, method, item);
    }

    protected <T> Future<Envelop> nextEnvelop(Vertx vertx, Method method, T result) {
        return TunnelClient.create(this.getClass()).connect(vertx).connect(method).send(Ux.to(result));
    }
}

