/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ipc.client;

import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.servicediscovery.Record;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.flux.IpcData;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.exception._501RpcAddressWrongException;
import io.vertx.up.exception._501RpcImplementException;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.discovery.IpcOrigin;
import io.vertx.up.micro.discovery.Origin;
import io.vertx.up.micro.ipc.DataEncap;
import io.vertx.up.micro.ipc.client.Spear;
import io.vertx.up.micro.ipc.client.UnitySpear;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class TunnelClient {
    private static final Origin ORIGIN = (Origin)Ut.singleton(IpcOrigin.class, (Object[])new Object[0]);
    private static final ConcurrentMap<IpcType, Spear> STUBS = new ConcurrentHashMap<IpcType, Spear>(){
        {
            this.put(IpcType.UNITY, Ut.singleton(UnitySpear.class, (Object[])new Object[0]));
        }
    };
    private final transient Annal logger;
    private transient Vertx vertx;
    private transient Method event;

    private TunnelClient(Class<?> clazz) {
        this.logger = Annal.get(clazz);
    }

    public static TunnelClient create(Class<?> clazz) {
        return new TunnelClient(clazz);
    }

    public TunnelClient connect(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public TunnelClient connect(Method event) {
        this.event = event;
        return this;
    }

    public Future<Envelop> send(Envelop envelop) {
        String address = (String)this.getValue("to");
        IpcType type = (IpcType)this.getValue("type");
        Record record = this.findTarget();
        IpcData data = new IpcData();
        data.setType(type);
        data.setAddress(address);
        DataEncap.in(data, record);
        DataEncap.in(data, envelop);
        Spear stub = STUBS.getOrDefault(type, (Spear)Ut.singleton(UnitySpear.class, (Object[])new Object[0]));
        return stub.send(this.vertx, data);
    }

    private <T> T getValue(String attr) {
        Ipc annotation = this.event.getAnnotation(Ipc.class);
        return (T)Ut.invoke((Object)annotation, (String)attr, (Object[])new Object[0]);
    }

    private Record findTarget() {
        ConcurrentMap<String, Record> address = ORIGIN.getRegistryData();
        String target = (String)this.getValue("to");
        String name = (String)this.getValue("name");
        List<Record> records = this.findRecords();
        Record record = records.stream().filter(item -> target.equals(item.getMetadata().getString("path"))).findAny().orElse(null);
        Fn.outWeb((null == record ? 1 : 0) != 0, (Annal)this.logger, _501RpcImplementException.class, (Object[])new Object[]{this.getClass(), name, target, this.event});
        Fn.outWeb((null == record.getMetadata() || !target.equals(record.getMetadata().getString("path")) ? 1 : 0) != 0, (Annal)this.logger, _501RpcAddressWrongException.class, (Object[])new Object[]{this.getClass(), target, name});
        this.logger.info("[ ZERO ] Find matched record {0}", new Object[]{record.toJson()});
        return record;
    }

    private List<Record> findRecords() {
        ConcurrentMap<String, Record> address = ORIGIN.getRegistryData();
        String name = (String)this.getValue("name");
        return address.values().stream().filter(item -> name.equals(item.getName())).collect(Collectors.toList());
    }
}

