/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro.ipc.server;

import io.grpc.BindableService;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.tp.ipc.eon.IpcRequest;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.tp.ipc.service.UnityServiceGrpc;
import io.vertx.up.annotations.Ipc;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.flux.IpcData;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.exception._501RpcMethodMissingException;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ipc.DataEncap;
import io.vertx.up.micro.ipc.server.Tunnel;
import io.vertx.up.micro.ipc.tower.FinalTransit;
import io.vertx.up.micro.ipc.tower.NodeTransit;
import io.vertx.up.micro.ipc.tower.Transit;
import io.zero.epic.Ut;
import java.lang.reflect.Method;

public class UnityTunnel
implements Tunnel {
    private static final Annal LOGGER = Annal.get(UnityTunnel.class);

    @Override
    public BindableService init(final Vertx vertx) {
        return new UnityServiceGrpc.UnityServiceVertxImplBase(){

            public void unityCall(IpcRequest request, Future<IpcResponse> future) {
                IpcData data = DataEncap.consume(request, IpcType.UNITY);
                Envelop envelop = DataEncap.consume(data);
                Method method = (Method)Tunnel.IPCS.get(data.getAddress());
                if (null == method) {
                    Envelop community = Envelop.failure(new _501RpcMethodMissingException(((Object)((Object)this)).getClass(), data.getAddress()));
                    IpcData responseData = UnityTunnel.this.build(community, envelop);
                    future.complete((Object)DataEncap.out(responseData));
                } else {
                    Transit transit = UnityTunnel.this.getTransit(method, vertx);
                    Future<Envelop> result = transit.async(envelop);
                    result.setHandler(res -> {
                        if (res.succeeded()) {
                            IpcData responseData = UnityTunnel.this.build((Envelop)res.result(), envelop);
                            future.complete((Object)DataEncap.out(responseData));
                        } else {
                            res.cause().printStackTrace();
                        }
                    });
                }
            }
        };
    }

    private IpcData build(Envelop community, Envelop envelop) {
        if (null != envelop) {
            community.setHeaders(envelop.headers());
            community.setUser(envelop.user());
        }
        IpcData responseData = new IpcData();
        responseData.setType(IpcType.UNITY);
        DataEncap.in(responseData, community);
        return responseData;
    }

    private Transit getTransit(Method method, Vertx vertx) {
        Transit transit;
        Ipc annotation = method.getAnnotation(Ipc.class);
        String to = (String)Ut.invoke((Object)annotation, (String)"to", (Object[])new Object[0]);
        if (Ut.isNil((String)to)) {
            transit = (Transit)Ut.singleton(FinalTransit.class, (Object[])new Object[0]);
            LOGGER.info("[ ZERO ] --> ( Terminator ) found, will provide response. method {0} of {1}", new Object[]{method, method.getDeclaringClass()});
        } else {
            transit = (Transit)Ut.singleton(NodeTransit.class, (Object[])new Object[0]);
            LOGGER.info("[ ZERO ] --> ( Coordinator ) found, will transfer -->. method {0} of {1}", new Object[]{method, method.getDeclaringClass()});
        }
        return transit.connect(vertx).connect(method);
    }
}

