/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.rpc;

import io.reactivex.Observable;
import io.vertx.core.json.JsonObject;
import io.vertx.servicediscovery.Record;
import io.vertx.up.eon.em.IpcType;
import io.vertx.up.exception._424RpcServiceException;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.discovery.IpcOrigin;
import io.vertx.up.micro.discovery.Origin;
import io.vertx.zero.atom.Ruler;
import io.zero.epic.Ut;
import io.zero.epic.container.RxHod;
import io.zero.epic.fn.Fn;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;

class RpcHelper {
    private static final Annal LOGGER = Annal.get(RpcHelper.class);
    private static final Origin ORIGIN = (Origin)Ut.singleton(IpcOrigin.class, (Object[])new Object[0]);

    RpcHelper() {
    }

    static Record getRecord(JsonObject config) {
        Fn.outUp(() -> Fn.shuntZero(() -> Ruler.verify((String)"rpcclient", (JsonObject)config), (Object[])new Object[]{config}), (Annal)LOGGER);
        ConcurrentMap<String, Record> registryData = ORIGIN.getRegistryData();
        String name = config.getString("name");
        String address = config.getString("addr");
        LOGGER.debug("[ ZERO ] ( Rpc Client ) Lookup service: name = {0}, addr = {1}", new Object[]{name, address});
        Fn.outWeb((boolean)registryData.values().isEmpty(), (Annal)LOGGER, _424RpcServiceException.class, (Object[])new Object[]{RpcHelper.class, name, address});
        RxHod container = new RxHod();
        Observable.fromIterable(registryData.values()).filter(Objects::nonNull).filter(item -> Ut.notNil((String)item.getName())).filter(item -> name.equals(item.getName()) && address.equals(item.getMetadata().getString("path"))).subscribe(arg_0 -> ((RxHod)container).add(arg_0));
        Fn.outWeb((!container.successed() ? 1 : 0) != 0, (Annal)LOGGER, _424RpcServiceException.class, (Object[])new Object[]{RpcHelper.class, name, address});
        Fn.outWeb((!container.successed() ? 1 : 0) != 0, (Annal)LOGGER, _424RpcServiceException.class, (Object[])new Object[]{RpcHelper.class, name, address});
        Record record = (Record)container.get();
        LOGGER.debug("[ ZERO ] ( Rpc Client ) Dynamic service record found: data = {0}", new Object[]{record.toJson()});
        return (Record)container.get();
    }

    static JsonObject normalize(String name, JsonObject config, Record record) {
        JsonObject ssl = RpcHelper.getSslConfig(name, config);
        JsonObject normalized = new JsonObject();
        normalized.put("host", record.getLocation().getString("host"));
        normalized.put("port", record.getLocation().getInteger("port"));
        normalized.put("ssl", ssl);
        return normalized;
    }

    static JsonObject getSslConfig(String name, JsonObject rpcConfig) {
        return (JsonObject)Fn.getNull((Object)new JsonObject(), () -> {
            JsonObject sslConfig = new JsonObject();
            if (rpcConfig.containsKey("ssl") && Boolean.valueOf(rpcConfig.getValue("ssl").toString()).booleanValue()) {
                JsonObject visited;
                if (rpcConfig.containsKey("extension") && null != (visited = Ut.visitJObject((JsonObject)rpcConfig, (String[])new String[]{"extension", name}))) {
                    sslConfig.mergeIn(visited);
                }
                if (sslConfig.isEmpty()) {
                    sslConfig.mergeIn(Ut.visitJObject((JsonObject)rpcConfig, (String[])new String[]{"uniform"}));
                }
            }
            return sslConfig;
        }, (Object[])new Object[]{rpcConfig});
    }

    static JsonObject on(String name, String addr, IpcType type) {
        JsonObject config = new JsonObject();
        config.put("name", name);
        config.put("addr", addr);
        config.put("type", (Enum)type);
        return config;
    }

    static JsonObject on(String name, String addr) {
        return RpcHelper.on(name, addr, IpcType.UNITY);
    }
}

