/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.rpc;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.tp.ipc.eon.IpcResponse;
import io.vertx.up.atom.Envelop;
import io.vertx.up.exception._500UnexpectedRpcException;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ipc.DataEncap;

public class RpcRepdor {
    private static final Annal LOGGER = Annal.get(RpcRepdor.class);
    private final transient Class<?> clazz;

    private RpcRepdor(Class<?> clazz) {
        this.clazz = clazz;
    }

    public static RpcRepdor create(Class<?> clazz) {
        return new RpcRepdor(clazz);
    }

    public void replyJson(Future<JsonObject> handler, AsyncResult<IpcResponse> response) {
        if (response.succeeded()) {
            Envelop json = DataEncap.out((IpcResponse)response.result());
            JsonObject data = (JsonObject)json.data();
            LOGGER.info("[ ZERO ] ( Rpc Client ) Response Json data is {0}", new Object[]{data});
            handler.complete((Object)data);
        } else {
            Throwable ex = response.cause();
            if (null != ex) {
                Envelop envelop = Envelop.failure(new _500UnexpectedRpcException(this.clazz, ex));
                handler.complete((Object)envelop.responseJson());
                ex.printStackTrace();
            }
        }
    }

    public void reply(Future<Envelop> handler, AsyncResult<IpcResponse> response) {
        if (response.succeeded()) {
            handler.complete((Object)DataEncap.out((IpcResponse)response.result()));
        } else {
            Throwable ex = response.cause();
            if (null != ex) {
                Envelop envelop = Envelop.failure(new _500UnexpectedRpcException(this.clazz, ex));
                handler.complete((Object)envelop);
                ex.printStackTrace();
            }
        }
    }
}

