/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.rpc;

import io.grpc.ManagedChannel;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.VertxChannelBuilder;
import io.vertx.up.atom.flux.IpcData;
import io.vertx.up.eon.em.CertType;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ssl.TrustPipe;
import io.vertx.up.plugin.rpc.RpcHelper;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroUniform;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class RpcSslTool {
    private static final Annal LOGGER = Annal.get(RpcSslTool.class);
    private static final Node<JsonObject> node = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private static final ConcurrentMap<String, ManagedChannel> CHANNELS = new ConcurrentHashMap<String, ManagedChannel>();

    public static ManagedChannel getChannel(Vertx vertx, JsonObject config) {
        String rpcHost = config.getString("host");
        Integer rpcPort = config.getInteger("port");
        return RpcSslTool.getChannel(rpcHost, rpcPort, () -> {
            VertxChannelBuilder builder = VertxChannelBuilder.forAddress((Vertx)vertx, (String)rpcHost, (int)rpcPort);
            Fn.safeSemi((null != config.getValue("ssl") ? 1 : 0) != 0, (Annal)LOGGER, () -> {
                JsonObject sslConfig = config.getJsonObject("ssl");
                if (null != sslConfig && !sslConfig.isEmpty()) {
                    Object type = sslConfig.getValue("type");
                    CertType certType = null == type ? CertType.PEM : (CertType)Ut.toEnum(CertType.class, (String)type.toString());
                    TrustPipe<JsonObject> pipe = TrustPipe.get(certType);
                    builder.useSsl(pipe.parse(sslConfig));
                } else {
                    builder.usePlaintext(true);
                }
            });
            ManagedChannel channel = builder.build();
            LOGGER.info("[ ZERO ] ( Rpc Client ) Build channel ( host = {0}, port = {1}, hashCode = {2} )", new Object[]{rpcHost, String.valueOf(rpcPort), String.valueOf(channel.hashCode())});
            return channel;
        });
    }

    private static ManagedChannel getChannel(String host, Integer port, Supplier<ManagedChannel> supplier) {
        String key = host + String.valueOf(port);
        return (ManagedChannel)Fn.pool(CHANNELS, (Object)key, supplier);
    }

    public static ManagedChannel getChannel(Vertx vertx, IpcData data) {
        String grpcHost = data.getHost();
        Integer grpcPort = data.getPort();
        return RpcSslTool.getChannel(grpcHost, grpcPort, () -> {
            LOGGER.info("[ ZERO ] Build channel for host = {0}, port = {1}", new Object[]{grpcHost, String.valueOf(grpcPort)});
            VertxChannelBuilder builder = VertxChannelBuilder.forAddress((Vertx)vertx, (String)grpcHost, (int)grpcPort);
            JsonObject config = (JsonObject)node.read();
            Fn.safeSemi((null != config && null != config.getValue("rpc") ? 1 : 0) != 0, (Annal)LOGGER, () -> {
                JsonObject rpcConfig = config.getJsonObject("rpc");
                String name = data.getName();
                JsonObject ssl = RpcHelper.getSslConfig(name, rpcConfig);
                if (ssl.isEmpty()) {
                    builder.usePlaintext(true);
                } else {
                    Object type = ssl.getValue("type");
                    CertType certType = null == type ? CertType.PEM : (CertType)Ut.toEnum(CertType.class, (String)type.toString());
                    TrustPipe<JsonObject> pipe = TrustPipe.get(certType);
                    builder.useSsl(pipe.parse(ssl));
                }
            });
            return builder.build();
        });
    }
}

