/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.plugin.shared;

import io.vertx.core.Vertx;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.plugin.Infix;
import io.vertx.up.plugin.shared.SharedClient;
import io.zero.epic.fn.Fn;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@Plugin
public class MapInfix
implements Infix {
    private static final String NAME = "ZERO_MAP_POOL";
    private static final ConcurrentMap<String, SharedClient<String, Object>> CLIENTS = new ConcurrentHashMap<String, SharedClient<String, Object>>();

    private static void initInternal(Vertx vertx, String name) {
        Fn.pool(CLIENTS, (Object)name, () -> (SharedClient)Infix.initTp((String)"shared", config -> SharedClient.createShared(vertx, config, name), MapInfix.class));
    }

    public static void init(Vertx vertx) {
        MapInfix.initInternal(vertx, NAME);
    }

    public static SharedClient<String, Object> getClient() {
        return (SharedClient)CLIENTS.get(NAME);
    }

    public static String getDefaultName() {
        return NAME;
    }

    public SharedClient<String, Object> get() {
        return MapInfix.getClient();
    }
}

