/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.config;

import io.vertx.core.DeploymentOptions;
import io.vertx.up.annotations.Worker;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Extractor;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class WorkerExtractor
implements Extractor<DeploymentOptions> {
    private static final Annal LOGGER = Annal.get(WorkerExtractor.class);
    private static final ConcurrentMap<Class<?>, DeploymentOptions> OPTIONS = new ConcurrentHashMap();

    @Override
    public DeploymentOptions extract(Class<?> clazz) {
        Fn.safeNull(() -> LOGGER.info("[ ZERO ] ( Worker ) The worker verticl {0} will be deployed.", new Object[]{clazz.getName()}), (Object[])new Object[]{clazz});
        return (DeploymentOptions)Fn.pool(OPTIONS, clazz, () -> this.transform(clazz));
    }

    private DeploymentOptions transform(Class<?> clazz) {
        Worker annotation = clazz.getDeclaredAnnotation(Worker.class);
        int instances = (Integer)Ut.invoke((Object)annotation, (String)"instances", (Object[])new Object[0]);
        boolean ha = (Boolean)Ut.invoke((Object)annotation, (String)"ha", (Object[])new Object[0]);
        String group = (String)Ut.invoke((Object)annotation, (String)"group", (Object[])new Object[0]);
        DeploymentOptions options = new DeploymentOptions();
        options.setHa(ha);
        options.setInstances(instances);
        options.setIsolationGroup(group);
        options.setWorker(true);
        LOGGER.info("[ ZERO ] ( Verticle ) The deployment options has been captured: instances = {0}, group = {1}, ha = {2}, content = {3}", new Object[]{instances, group, ha, options.toJson()});
        return options;
    }
}

