/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.hunt;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.up.annotations.SessionData;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.agent.Event;
import io.zero.epic.Ut;
import java.lang.reflect.Method;
import java.util.Set;
import javax.ws.rs.core.MediaType;

public final class Normalizer {
    static HttpServerResponse initialize(RoutingContext context, Envelop envelop) {
        HttpServerResponse response = context.response();
        HttpStatusCode code = envelop.status();
        response.setStatusCode(code.code());
        response.setStatusMessage(code.message());
        return response;
    }

    static <T> void storeSession(RoutingContext context, T data, Method method) {
        Session session = context.session();
        if (null != session && null != data && method.isAnnotationPresent(SessionData.class)) {
            SessionData annotation = method.getAnnotation(SessionData.class);
            String key = (String)Ut.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
            String field = (String)Ut.invoke((Object)annotation, (String)"field", (Object[])new Object[0]);
            Object reference = data;
            if (Ut.isJObject(data) && Ut.notNil((String)field)) {
                JsonObject target = (JsonObject)data;
                reference = target.getValue(field);
            }
            session.put(key, reference);
        }
    }

    static void media(HttpServerResponse response, Event event) {
        if (null == event) {
            response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
        } else {
            Set<MediaType> produces = event.getProduces();
            if (produces.contains(MediaType.WILDCARD_TYPE)) {
                response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
            } else {
                MediaType type = produces.iterator().next();
                if (null != type) {
                    String content = type.getType() + "/" + type.getSubtype();
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)content);
                } else {
                    response.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json");
                }
            }
        }
    }

    static void out(HttpServerResponse response, Envelop envelop, Event event) {
        if (!response.ended()) {
            String headerStr = response.headers().get(HttpHeaders.CONTENT_TYPE);
            if (null == headerStr) {
                response.end(envelop.responseString());
            } else {
                MediaType type = MediaType.valueOf((String)headerStr);
                if (MediaType.WILDCARD_TYPE.equals((Object)type)) {
                    response.end(envelop.responseString());
                } else if (MediaType.APPLICATION_OCTET_STREAM_TYPE.equals((Object)type)) {
                    response.end(envelop.responseBuffer());
                } else {
                    response.end(envelop.responseString());
                }
            }
        }
        response.close();
    }
}

