/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.router;

import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.PlugRouter;
import io.vertx.up.rs.router.Pool;
import io.vertx.up.web.ZeroAmbient;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroUniform;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.concurrent.atomic.AtomicInteger;

public class DynamicAxis
implements Axis<Router> {
    private static final String KEY_ROUTER = "router";
    private static final Annal LOGGER = Annal.get(DynamicAxis.class);
    private static final AtomicInteger LOG_FLAG_START = new AtomicInteger(0);
    private static final AtomicInteger LOG_FLAG_END = new AtomicInteger(0);
    private static final transient String NAME = DynamicAxis.class.getSimpleName();
    private final transient Node<JsonObject> uniform = (Node)Ut.singleton(ZeroUniform.class, (Object[])new Object[0]);
    private transient Vertx vertxRef;

    @Override
    public void mount(Router router) {
        Class clazz = ZeroAmbient.getPlugin((String)KEY_ROUTER);
        if (0 == LOG_FLAG_START.getAndIncrement()) {
            LOGGER.info("[ ZERO ] ( {0} ) The system is detecting dynamic routing component...", new Object[]{NAME});
        }
        if (null != clazz && Ut.isImplement((Class)clazz, PlugRouter.class)) {
            JsonObject config = (JsonObject)this.uniform.read();
            JsonObject routerConfig = (JsonObject)Fn.getNull((Object)new JsonObject(), () -> config.getJsonObject(KEY_ROUTER), (Object[])new Object[]{config});
            if (1 == LOG_FLAG_END.getAndIncrement()) {
                LOGGER.info("[ ZERO ] ( {0} ) Zero system detect class {1} ( io.vertx.up.rs.PlugRouter ) with config {2}.", new Object[]{NAME, clazz.getName(), routerConfig.encode()});
            }
            PlugRouter plugRouter = (PlugRouter)Fn.poolThread(Pool.PLUGS, () -> (PlugRouter)Ut.instance((Class)clazz, (Object[])new Object[0]));
            plugRouter.bind(this.vertxRef);
            plugRouter.mount(router, routerConfig);
        } else if (1 == LOG_FLAG_END.getAndIncrement()) {
            LOGGER.info("[ ZERO ] ( {0} ) Skip dynamic routing because clazz is null or class {1} is not assignable from \"io.vertx.up.rs.PlugRouter\".", new Object[]{NAME, Fn.getNull(null, () -> null == clazz ? null : clazz.getName(), (Object[])new Object[]{clazz})});
        }
    }

    public Axis<Router> bind(Vertx vertx) {
        this.vertxRef = vertx;
        return this;
    }
}

