/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.router;

import io.reactivex.Observable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.AuthHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.up.atom.secure.Cliff;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.router.Pool;
import io.vertx.up.rs.secure.Bolt;
import io.vertx.up.web.ZeroAnno;
import io.vertx.up.web.failure.AuthenticateEndurer;
import java.util.Set;
import java.util.TreeSet;

public class WallAxis
implements Axis<Router> {
    private static final Set<Cliff> WALLS = ZeroAnno.getWalls();
    private final transient Vertx vertx;
    private final transient Bolt bolt;

    public WallAxis(Vertx vertx) {
        this.vertx = vertx;
        this.bolt = Bolt.get();
    }

    @Override
    public void mount(Router router) {
        router.route().order(1600000).handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)));
        Pool.WALL_MAP.forEach((path, cliffes) -> {
            AuthHandler handler = this.create(this.vertx, (Set<Cliff>)cliffes);
            if (null != handler) {
                router.route(path).order(1900000).handler((Handler)handler).failureHandler(AuthenticateEndurer.create());
            }
        });
    }

    private AuthHandler create(Vertx vertx, Set<Cliff> cliffes) {
        AuthHandler resultHandler = null;
        if (1 < cliffes.size()) {
            ChainAuthHandler chain = ChainAuthHandler.create();
            Observable.fromIterable(cliffes).map(item -> this.bolt.mount(vertx, (Cliff)item)).subscribe(arg_0 -> ((ChainAuthHandler)chain).append(arg_0)).dispose();
            resultHandler = chain;
        } else if (!cliffes.isEmpty()) {
            Cliff cliff = cliffes.iterator().next();
            resultHandler = this.bolt.mount(vertx, cliff);
        }
        return resultHandler;
    }

    static {
        WALLS.forEach(wall -> {
            if (!Pool.WALL_MAP.containsKey(wall.getPath())) {
                Pool.WALL_MAP.put(wall.getPath(), new TreeSet());
            }
            ((Set)Pool.WALL_MAP.get(wall.getPath())).add(wall);
        });
    }
}

