/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.provider;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.shareddata.AsyncMap;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.jwt.JWTAuthOptions;
import io.vertx.ext.auth.jwt.impl.JWTUser;
import io.vertx.ext.jwt.JWT;
import io.vertx.ext.jwt.JWTOptions;
import io.vertx.up.aiki.Ux;
import io.vertx.up.exception.WebException;
import io.vertx.up.exception._401JwtAudientException;
import io.vertx.up.exception._401JwtExecutorException;
import io.vertx.up.exception._401JwtExpiredException;
import io.vertx.up.exception._401JwtIssuerException;
import io.vertx.up.exception._403ForbiddenException;
import io.vertx.up.exception._500JwtRuntimeException;
import io.vertx.up.log.Annal;
import io.vertx.up.secure.Security;
import io.vertx.up.secure.provider.JwtAuth;
import io.vertx.up.secure.provider.JwtSecurer;
import java.util.Collections;
import java.util.function.Supplier;

public class JwtAuthProvider
implements JwtAuth {
    private static final JsonArray EMPTY_ARRAY = new JsonArray();
    private static final String AUTH_POOL = "JWT_AUTH_TOKEN_POOL";
    private static final Annal LOGGER = Annal.get(JwtAuthProvider.class);
    private final JWT jwt;
    private final String permissionsClaimKey;
    private final JWTOptions jwtOptions;
    private transient JwtSecurer securer;
    private transient AsyncMap<String, Boolean> authorizeMap;

    public JwtAuthProvider(Vertx vertx, JWTAuthOptions config) {
        this.permissionsClaimKey = config.getPermissionsClaimKey();
        this.jwtOptions = config.getJWTOptions();
        this.jwt = Ux.Jwt.create(config, arg_0 -> ((FileSystem)vertx.fileSystem()).readFileBlocking(arg_0));
        vertx.sharedData().getAsyncMap(AUTH_POOL, res -> {
            if (res.succeeded()) {
                LOGGER.debug("[ ZERO ] ( Auth ) The async shared map has been initialized: name = {0}", new Object[]{AUTH_POOL});
                this.authorizeMap = (AsyncMap)res.result();
            }
        });
    }

    @Override
    public JwtAuth bind(Supplier<Security> supplier) {
        Security security = supplier.get();
        this.securer = JwtSecurer.create(security);
        return this;
    }

    public void authenticate(JsonObject authInfo, Handler<AsyncResult<User>> resultHandler) {
        String token = authInfo.getString("jwt");
        if (null == this.authorizeMap) {
            this.authenticate(authInfo).setHandler(this.authorized(token, resultHandler));
        } else {
            this.authorizeMap.get((Object)token, res -> {
                if (null != res && null != res.result() && ((Boolean)res.result()).booleanValue()) {
                    LOGGER.info("[ ZERO ] ( Auth ) The async shared map cache has been hitted by key = {0}, value = {1}", new Object[]{token, res.result()});
                    this.verify403(authInfo).compose(authorized -> this.authorize(authInfo).setHandler(this.authorized(token, resultHandler)));
                } else {
                    LOGGER.debug("[ ZERO ] ( Auth ) The async shared map cache has not been hitted by key = {0}", new Object[]{token});
                    this.authenticate(authInfo).setHandler(this.authorized(token, resultHandler));
                }
            });
        }
    }

    private Handler<AsyncResult<User>> authorized(String token, Handler<AsyncResult<User>> handler) {
        return user -> this.authorizeMap.get((Object)token, res -> {
            if (null == res || null == res.result() || !((Boolean)res.result()).booleanValue()) {
                this.authorizeMap.put((Object)token, (Object)Boolean.TRUE, result -> {
                    LOGGER.debug("[ ZERO ] ( Auth ) The async shared map cache has been put with key = {0}, value = {1}", new Object[]{token, Boolean.TRUE});
                    handler.handle((Object)Future.succeededFuture((Object)user.result()));
                });
            } else {
                handler.handle((Object)Future.succeededFuture((Object)user.result()));
            }
        });
    }

    private Future<User> verify401(JsonObject authInfo) {
        return this.securer.authenticate(authInfo).compose(verified -> {
            if (verified.booleanValue()) {
                return this.verify403(authInfo);
            }
            return Future.failedFuture((Throwable)((Object)new _401JwtExecutorException(this.getClass(), authInfo.getString("jwt"))));
        });
    }

    private Future<User> verify403(JsonObject authInfo) {
        return this.securer.authorize(authInfo).compose(verfied -> {
            if (verfied.booleanValue()) {
                return this.authorize(authInfo);
            }
            return Future.failedFuture((Throwable)((Object)new _403ForbiddenException(this.getClass())));
        });
    }

    private Future<User> authenticate(JsonObject authInfo) {
        if (null == this.securer) {
            return this.authorize(authInfo);
        }
        try {
            return this.verify401(authInfo);
        }
        catch (WebException ex) {
            return Future.failedFuture((Throwable)ex);
        }
    }

    private Future<User> authorize(JsonObject authInfo) {
        try {
            JsonObject payload = this.jwt.decode(authInfo.getString("jwt"));
            if (this.jwt.isExpired(payload, this.jwtOptions)) {
                return Future.failedFuture((Throwable)((Object)new _401JwtExpiredException(this.getClass(), payload)));
            }
            if (this.jwtOptions.getAudience() != null) {
                JsonArray target = payload.getValue("aud") instanceof String ? new JsonArray().add(payload.getValue("aud", (Object)"")) : payload.getJsonArray("aud", EMPTY_ARRAY);
                if (Collections.disjoint(this.jwtOptions.getAudience(), target.getList())) {
                    return Future.failedFuture((Throwable)((Object)new _401JwtAudientException(this.getClass(), Json.encode((Object)this.jwtOptions.getAudience()))));
                }
            }
            if (this.jwtOptions.getIssuer() != null && !this.jwtOptions.getIssuer().equals(payload.getString("iss"))) {
                return Future.failedFuture((Throwable)((Object)new _401JwtIssuerException(this.getClass(), payload.getString("iss"))));
            }
            return Future.succeededFuture((Object)new JWTUser(payload, this.permissionsClaimKey));
        }
        catch (RuntimeException var5) {
            return Future.failedFuture((Throwable)((Object)new _500JwtRuntimeException(this.getClass(), var5)));
        }
    }

    @Override
    public String generateToken(JsonObject claims, JWTOptions options) {
        JsonObject _claims = claims.copy();
        if (options.getPermissions() != null && !_claims.containsKey(this.permissionsClaimKey)) {
            _claims.put(this.permissionsClaimKey, new JsonArray(options.getPermissions()));
        }
        return this.jwt.sign(_claims, options);
    }
}

