/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.secure.provider;

import io.vertx.core.Future;
import io.vertx.core.json.JsonObject;
import io.vertx.up.secure.Security;

class JwtSecurer {
    private final transient Security security;

    private JwtSecurer(Security security) {
        this.security = security;
    }

    static JwtSecurer create(Security security) {
        return new JwtSecurer(security);
    }

    Future<Boolean> authenticate(JsonObject authInfo) {
        return this.security.verify(authInfo);
    }

    Future<Boolean> authorize(JsonObject authInfo) {
        return this.security.access(authInfo);
    }
}

