/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web;

import io.vertx.up.atom.agent.Event;
import io.vertx.up.atom.secure.Cliff;
import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.matcher.RegexPath;
import io.vertx.up.web.origin.AffluxInquirer;
import io.vertx.up.web.origin.AgentInquirer;
import io.vertx.up.web.origin.EndPointInquirer;
import io.vertx.up.web.origin.EventInquirer;
import io.vertx.up.web.origin.FilterInquirer;
import io.vertx.up.web.origin.Inquirer;
import io.vertx.up.web.origin.IpcInquirer;
import io.vertx.up.web.origin.PluginInquirer;
import io.vertx.up.web.origin.PointerInquirer;
import io.vertx.up.web.origin.QueueInquirer;
import io.vertx.up.web.origin.ReceiptInquirer;
import io.vertx.up.web.origin.WallInquirer;
import io.vertx.up.web.origin.WorkerInquirer;
import io.vertx.zero.mirror.Pack;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class ZeroAnno {
    private static final Annal LOGGER = Annal.get(ZeroAnno.class);
    private static final Set<Class<?>> ENDPOINTS = new HashSet();
    private static final ConcurrentMap<Class<?>, ConcurrentMap<String, Class<?>>> PLUGINS = new ConcurrentHashMap();
    private static final Set<Receipt> RECEIPTS = new HashSet<Receipt>();
    private static final Set<Event> EVENTS = new HashSet<Event>();
    private static final ConcurrentMap<String, Set<Event>> FILTERS = new ConcurrentHashMap<String, Set<Event>>();
    private static final ConcurrentMap<ServerType, List<Class<?>>> AGENTS = new ConcurrentHashMap();
    private static final Set<Class<?>> WORKERS = new HashSet();
    private static final Set<Cliff> WALLS = new TreeSet<Cliff>();
    private static final ConcurrentMap<String, Method> IPCS = new ConcurrentHashMap<String, Method>();
    private static final Set<Class<?>> POINTER = new HashSet();
    private static final Set<Class<?>> TPS = new HashSet();
    private static final Set<String> URI_PATHS = new HashSet<String>();

    public static ConcurrentMap<Class<?>, ConcurrentMap<String, Class<?>>> getPlugins() {
        return PLUGINS;
    }

    public static ConcurrentMap<ServerType, List<Class<?>>> getAgents() {
        return AGENTS;
    }

    public static Set<Class<?>> getInjects() {
        return POINTER;
    }

    public static Set<Class<?>> getTps() {
        return TPS;
    }

    public static Set<Class<?>> getWorkers() {
        return WORKERS;
    }

    public static Set<Receipt> getReceipts() {
        return RECEIPTS;
    }

    public static Set<Class<?>> getEndpoints() {
        return ENDPOINTS;
    }

    public static ConcurrentMap<String, Method> getIpcs() {
        return IPCS;
    }

    public static Set<Event> getEvents() {
        return EVENTS;
    }

    public static ConcurrentMap<String, Set<Event>> getFilters() {
        return FILTERS;
    }

    public static Set<Cliff> getWalls() {
        return WALLS;
    }

    public static String recoveryUri(String uri) {
        return URI_PATHS.stream().filter(path -> ZeroAnno.isMatch(uri, path)).findFirst().orElse(uri);
    }

    private static boolean isMatch(String uri, String path) {
        Pattern pattern = RegexPath.createRegex(path);
        return pattern.matcher(uri).matches();
    }

    static {
        Set clazzes = Pack.getClasses(null, (String[])new String[0]);
        Inquirer inquirer = (Inquirer)Ut.singleton(EndPointInquirer.class, (Object[])new Object[0]);
        ENDPOINTS.addAll((Collection)inquirer.scan(clazzes));
        Fn.safeSemi((!ENDPOINTS.isEmpty() ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Inquirer event = (Inquirer)Ut.singleton(EventInquirer.class, (Object[])new Object[0]);
            EVENTS.addAll((Collection)event.scan(ENDPOINTS));
        });
        EVENTS.stream().map(Event::getPath).filter(Objects::nonNull).filter(item -> 0 < item.indexOf(":")).forEach(URI_PATHS::add);
        Inquirer walls = (Inquirer)Ut.singleton(WallInquirer.class, (Object[])new Object[0]);
        WALLS.addAll((Collection)walls.scan(clazzes));
        Inquirer filters = (Inquirer)Ut.singleton(FilterInquirer.class, (Object[])new Object[0]);
        FILTERS.putAll((Map)filters.scan(clazzes));
        inquirer = (Inquirer)Ut.singleton(QueueInquirer.class, (Object[])new Object[0]);
        Set queues = (Set)inquirer.scan(clazzes);
        Fn.safeSemi((!queues.isEmpty() ? 1 : 0) != 0, (Annal)LOGGER, () -> {
            Inquirer receipt = (Inquirer)Ut.singleton(ReceiptInquirer.class, (Object[])new Object[0]);
            RECEIPTS.addAll((Collection)receipt.scan(queues));
        });
        Inquirer ipc = (Inquirer)Ut.singleton(IpcInquirer.class, (Object[])new Object[0]);
        IPCS.putAll((Map)ipc.scan(clazzes));
        Inquirer agent = (Inquirer)Ut.singleton(AgentInquirer.class, (Object[])new Object[0]);
        AGENTS.putAll((Map)agent.scan(clazzes));
        Inquirer pointer = (Inquirer)Ut.singleton(PointerInquirer.class, (Object[])new Object[0]);
        POINTER.addAll((Collection)pointer.scan(clazzes));
        Inquirer tps = (Inquirer)Ut.singleton(PluginInquirer.class, (Object[])new Object[0]);
        TPS.addAll((Collection)tps.scan(clazzes));
        Inquirer worker = (Inquirer)Ut.singleton(WorkerInquirer.class, (Object[])new Object[0]);
        WORKERS.addAll((Collection)worker.scan(clazzes));
        Inquirer afflux = (Inquirer)Ut.singleton(AffluxInquirer.class, (Object[])new Object[0]);
        PLUGINS.putAll((Map)afflux.scan(clazzes));
    }
}

