/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.anima;

import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.Plugins;
import io.vertx.up.log.Annal;
import io.vertx.up.plugin.Infix;
import io.vertx.up.web.ZeroAmbient;
import io.vertx.up.web.anima.Pool;
import io.vertx.zero.exception.InjectionLimeKeyException;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroUniform;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Set;

class AffluxInfix {
    private final transient Class<?> clazz;
    private final transient Annal logger;

    private AffluxInfix(Class<?> clazz) {
        this.clazz = clazz;
        this.logger = Annal.get(clazz);
    }

    static AffluxInfix create(Class<?> clazz) {
        return (AffluxInfix)Fn.pool(Pool.INFIXES, clazz, () -> new AffluxInfix(clazz));
    }

    private Class<? extends Annotation> search(Field field) {
        Annotation[] annotations = field.getDeclaredAnnotations();
        Set annotationCls = Plugins.INFIX_MAP.keySet();
        Class<? extends Annotation> hitted = null;
        for (Annotation annotation : annotations) {
            if (!annotationCls.contains(annotation.annotationType())) continue;
            hitted = annotation.annotationType();
            break;
        }
        return hitted;
    }

    Object inject(Field field) {
        Class<? extends Annotation> key = this.search(field);
        String pluginKey = (String)Plugins.INFIX_MAP.get(key);
        Class infixCls = ZeroAmbient.getPlugin((String)pluginKey);
        Object ret = null;
        if (null != infixCls) {
            if (Ut.isImplement((Class)infixCls, Infix.class)) {
                Node node = (Node)Ut.instance(ZeroUniform.class, (Object[])new Object[0]);
                JsonObject options = (JsonObject)node.read();
                Fn.outUp((!options.containsKey(pluginKey) ? 1 : 0) != 0, (Annal)this.logger, InjectionLimeKeyException.class, (Object[])new Object[]{this.clazz, infixCls, pluginKey});
                Infix reference = (Infix)Ut.singleton((Class)infixCls, (Object[])new Object[0]);
                ret = Ut.invoke((Object)reference, (String)"get", (Object[])new Object[0]);
            } else {
                this.logger.warn("[ ZERO ] The hitted class {0} does not implement the interfaceof {1}", new Object[]{infixCls.getName(), Infix.class.getName()});
            }
        } else {
            this.logger.warn("[ ZERO ] The system scanned null infix for key = {0} on the field \"{1}\" of {2}", new Object[]{pluginKey, field.getName(), field.getDeclaringClass().getName()});
        }
        return ret;
    }
}

