/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.anima;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Vertx;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Extractor;
import io.vertx.up.rs.config.AgentExtractor;
import io.vertx.up.web.anima.Scatter;
import io.vertx.up.web.anima.Verticles;
import io.vertx.up.web.limit.Factor;
import io.vertx.up.web.limit.HttpFactor;
import io.zero.epic.Ut;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AgentScatter
implements Scatter<Vertx> {
    private static final Annal LOGGER = Annal.get(AgentScatter.class);
    private final transient Factor factor = (Factor)Ut.singleton(HttpFactor.class, (Object[])new Object[0]);

    @Override
    public void connect(Vertx vertx) {
        ConcurrentMap<ServerType, Class<?>> agents = this.factor.agents();
        Extractor extractor = (Extractor)Ut.instance(AgentExtractor.class, (Object[])new Object[0]);
        ConcurrentHashMap options = new ConcurrentHashMap();
        Ut.itMap(agents, (type, clazz) -> {
            DeploymentOptions option = (DeploymentOptions)extractor.extract((Class<?>)clazz);
            options.put(clazz, option);
            Verticles.deploy(vertx, clazz, option, LOGGER);
        });
        Runtime.getRuntime().addShutdownHook(new Thread(() -> Ut.itMap((ConcurrentMap)agents, (type, clazz) -> {
            DeploymentOptions opt = (DeploymentOptions)options.get(clazz);
            Verticles.undeploy(vertx, clazz, opt, LOGGER);
        })));
    }
}

