/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.anima;

import io.reactivex.Observable;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.log.Annal;
import io.vertx.up.plugin.Infix;
import io.vertx.up.web.ZeroAmbient;
import io.vertx.up.web.anima.Pool;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

class InfixPlugin {
    private final transient Class<?> clazz;
    private final transient Annal logger;

    private InfixPlugin(Class<?> clazz) {
        this.clazz = clazz;
        this.logger = Annal.get(clazz);
    }

    static InfixPlugin create(Class<?> clazz) {
        return (InfixPlugin)Fn.pool(Pool.PLUGINS, clazz, () -> new InfixPlugin(clazz));
    }

    void inject(Object proxy) {
        ConcurrentMap<Class<?>, Class<?>> binds = this.getBind();
        Class<?> type = proxy.getClass();
        Observable.fromArray((Object[])type.getDeclaredFields()).filter(field -> field.isAnnotationPresent(Plugin.class)).subscribe(field -> {
            Class<?> fieldType = field.getType();
            Class infixCls = (Class)binds.get(fieldType);
            if (null != infixCls) {
                if (Ut.isImplement((Class)infixCls, Infix.class)) {
                    Infix reference = (Infix)Ut.singleton((Class)infixCls, (Object[])new Object[0]);
                    Object tpRef = Ut.invoke((Object)reference, (String)"get", (Object[])new Object[0]);
                    String fieldName = field.getName();
                    Ut.field((Object)proxy, (String)fieldName, (Object)tpRef);
                } else {
                    this.logger.warn("[ ZERO ] The hitted class {0} does not implement the interfaceof {1}", new Object[]{infixCls.getName(), Infix.class.getName()});
                }
            } else {
                this.logger.warn("[ ZERO ] The system scanned null infix for key = {0} on the field \"{1}\" of {2}", new Object[]{"tp", field.getName(), type.getName()});
            }
        });
    }

    private ConcurrentMap<Class<?>, Class<?>> getBind() {
        HashSet infixes = new HashSet(ZeroAmbient.getInjections().values());
        ConcurrentHashMap binds = new ConcurrentHashMap();
        Observable.fromIterable(infixes).filter(Infix.class::isAssignableFrom).subscribe(item -> {
            Method method = (Method)Fn.getJvm(() -> item.getDeclaredMethod("get", new Class[0]), (Object[])new Object[]{item});
            Class<?> type = method.getReturnType();
            binds.put(type, (Class<?>)item);
        });
        return binds;
    }
}

