/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.anima;

import io.reactivex.Observable;
import io.vertx.core.Vertx;
import io.vertx.tp.error.PluginSpecificationException;
import io.vertx.up.annotations.Plugin;
import io.vertx.up.eon.Plugins;
import io.vertx.up.log.Annal;
import io.vertx.up.web.Runner;
import io.vertx.up.web.ZeroAmbient;
import io.vertx.up.web.ZeroAnno;
import io.vertx.up.web.anima.InfixPlugin;
import io.vertx.up.web.anima.Scatter;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroLime;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

public class InfixScatter
implements Scatter<Vertx> {
    private static final Annal LOGGER = Annal.get(InfixScatter.class);
    private static final Node<ConcurrentMap<String, String>> node = (Node)Ut.singleton(ZeroLime.class, (Object[])new Object[0]);
    private static final Set<Class<?>> PLUGINS = ZeroAnno.getTps();
    private static final InfixPlugin PLUGIN = InfixPlugin.create(InfixScatter.class);

    @Override
    public void connect(Vertx vertx) {
        ConcurrentMap wholeInjections = ZeroAmbient.getInjections();
        ConcurrentMap enabled = Ut.reduce(((ConcurrentMap)node.read()).keySet(), (ConcurrentMap)wholeInjections);
        ConcurrentMap injections = Ut.reduce((ConcurrentMap)Plugins.INFIX_MAP, (ConcurrentMap)enabled);
        injections.values().stream().forEach(item -> {
            if (null != item && item.isAnnotationPresent(Plugin.class)) {
                Method method = this.findInit((Class<?>)item);
                Fn.outUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, PluginSpecificationException.class, (Object[])new Object[]{this.getClass(), item.getName()});
                Fn.safeJvm(() -> method.invoke(null, vertx), (Annal)LOGGER);
            }
        });
        Observable.fromIterable(wholeInjections.keySet()).filter(key -> !Plugins.Infix.STANDAND.contains(key)).map(wholeInjections::get).filter(item -> null != item && item.isAnnotationPresent(Plugin.class)).subscribe(item -> {
            Method method = this.findInit((Class<?>)item);
            Fn.outUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, PluginSpecificationException.class, (Object[])new Object[]{this.getClass(), item.getName()});
            Fn.safeJvm(() -> method.invoke(null, vertx), (Annal)LOGGER);
        });
        Ut.itSet(PLUGINS, (clazz, index) -> Runner.run(() -> {
            Object reference = Ut.singleton((Class)clazz, (Object[])new Object[0]);
            PLUGIN.inject(reference);
        }, (String)"injects-plugin-scannner"));
    }

    private Method findInit(Class<?> clazz) {
        return (Method)Fn.getNull(() -> {
            Method[] methods = clazz.getDeclaredMethods();
            List found = Arrays.stream(methods).filter(item -> "init".equals(item.getName()) && this.validMethod((Method)item)).collect(Collectors.toList());
            return 1 == found.size() ? (Method)found.get(0) : null;
        }, (Object[])new Object[]{clazz});
    }

    private boolean validMethod(Method method) {
        return (Void.TYPE == method.getReturnType() || Void.class == method.getReturnType()) && Modifier.isStatic(method.getModifiers()) && Modifier.isPublic(method.getModifiers());
    }
}

