/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.limit;

import io.vertx.tp.error.RpcPreparingException;
import io.vertx.tp.etcd.center.EtcdData;
import io.vertx.up.boot.Motor;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ZeroHttpAgent;
import io.vertx.up.micro.ZeroRpcAgent;
import io.vertx.up.micro.ZeroSockAgent;
import io.vertx.up.web.limit.Factor;
import io.zero.epic.fn.Fn;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class HttpFactor
implements Factor {
    private static final Annal LOGGER = Annal.get(HttpFactor.class);
    private static final Class<?>[] DEFAULT_AGENTS = new Class[]{ZeroHttpAgent.class, ZeroRpcAgent.class, ZeroSockAgent.class};
    private static final ConcurrentMap<ServerType, Class<?>> INTERNALS = new ConcurrentHashMap<ServerType, Class<?>>(){
        {
            this.put(ServerType.HTTP, ZeroHttpAgent.class);
            this.put(ServerType.IPC, ZeroRpcAgent.class);
            this.put(ServerType.SOCK, ZeroSockAgent.class);
        }
    };

    @Override
    public ConcurrentMap<ServerType, Class<?>> agents() {
        ConcurrentMap<ServerType, Class<?>> agents = Motor.agents(ServerType.HTTP, DEFAULT_AGENTS, INTERNALS);
        if (agents.containsKey(ServerType.IPC)) {
            Fn.outUp((!EtcdData.enabled() ? 1 : 0) != 0, (Annal)LOGGER, RpcPreparingException.class, (Object[])new Object[]{this.getClass()});
        }
        HashSet scanned = new HashSet(agents.keySet());
        Set keeped = INTERNALS.keySet();
        scanned.removeAll(keeped);
        scanned.forEach(agents::remove);
        return agents;
    }
}

