/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.web.origin;

import io.vertx.up.atom.worker.Receipt;
import io.vertx.up.log.Annal;
import io.vertx.up.web.origin.Inquirer;
import io.vertx.up.web.thread.QueueThread;
import io.zero.epic.fn.Fn;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class ReceiptInquirer
implements Inquirer<Set<Receipt>> {
    private static final Annal LOGGER = Annal.get(ReceiptInquirer.class);

    @Override
    public Set<Receipt> scan(Set<Class<?>> queues) {
        ArrayList<QueueThread> threadReference = new ArrayList<QueueThread>();
        for (Class<?> queue : queues) {
            QueueThread thread = new QueueThread(queue);
            threadReference.add(thread);
            thread.start();
        }
        Fn.safeJvm(() -> {
            for (QueueThread item : threadReference) {
                item.join();
            }
        }, (Annal)LOGGER);
        HashSet<Receipt> receipts = new HashSet<Receipt>();
        Fn.safeJvm(() -> {
            for (QueueThread item : threadReference) {
                receipts.addAll(item.getReceipts());
            }
        }, (Annal)LOGGER);
        return receipts;
    }
}

