/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.micro.config;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.eon.em.ServerType;
import io.vertx.up.log.Annal;
import io.vertx.zero.config.ServerVisitor;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.demon.ServerConfigException;
import io.vertx.zero.marshal.node.Node;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NamesVisitor
implements ServerVisitor<String> {
    private final transient Node<JsonObject> NODE = Node.infix((String)"server");
    private transient ServerType type = null;

    public ConcurrentMap<Integer, String> visit(String ... key) throws ZeroException {
        Ut.ensureEqualLength(this.getClass(), (int)1, (Object[])key);
        JsonObject data = (JsonObject)this.NODE.read();
        Fn.outZero((null == data || !data.containsKey("server") ? 1 : 0) != 0, (Annal)this.getLogger(), ServerConfigException.class, (Object[])new Object[]{this.getClass(), null == data ? null : data.encode()});
        JsonArray raw = data.getJsonArray("server");
        this.type = ServerType.valueOf((String)key[0]);
        return this.extract(raw);
    }

    private ConcurrentMap<Integer, String> extract(JsonArray serverData) {
        ConcurrentHashMap<Integer, String> map = new ConcurrentHashMap<Integer, String>();
        Ut.itJArray((JsonArray)serverData, JsonObject.class, (item, index) -> {
            if (this.isServer((JsonObject)item)) {
                int port = this.extractPort(item.getJsonObject("config"));
                Fn.safeNull(() -> map.put(port, item.getString("name")), (Object[])new Object[]{port});
            }
        });
        return map;
    }

    private boolean isServer(JsonObject item) {
        return null != this.type && this.type.match(item.getString("type"));
    }

    private int extractPort(JsonObject config) {
        if (null != config) {
            return config.getInteger("port", Integer.valueOf(80));
        }
        return 80;
    }

    protected Annal getLogger() {
        return Annal.get(this.getClass());
    }
}

