/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.zero.micro.config;

import io.vertx.core.ClusterOptions;
import io.vertx.core.VertxOptions;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.up.log.Annal;
import io.vertx.zero.atom.Ruler;
import io.vertx.zero.config.NodeVisitor;
import io.vertx.zero.exception.ZeroException;
import io.vertx.zero.exception.demon.ClusterConflictException;
import io.vertx.zero.marshal.Transformer;
import io.vertx.zero.marshal.node.Node;
import io.vertx.zero.marshal.node.ZeroVertx;
import io.vertx.zero.micro.config.ClusterStrada;
import io.vertx.zero.micro.config.VertxStrada;
import io.zero.epic.Ut;
import io.zero.epic.fn.Fn;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class VertxVisitor
implements NodeVisitor {
    private static final Annal LOGGER = Annal.get(VertxVisitor.class);
    private static final String KEY = "vertx";
    private final transient Node<JsonObject> NODE = (Node)Ut.singleton(ZeroVertx.class, (Object[])new Object[0]);
    private final transient Transformer<VertxOptions> transformer = (Transformer)Ut.singleton(VertxStrada.class, (Object[])new Object[0]);
    private final transient Transformer<ClusterOptions> clusterTransformer = (Transformer)Ut.singleton(ClusterStrada.class, (Object[])new Object[0]);
    private transient ClusterOptions clusterOptions;

    public ConcurrentMap<String, VertxOptions> visit(String ... keys) throws ZeroException {
        Ut.ensureEqualLength(this.getClass(), (int)0, (Object[])keys);
        JsonObject data = (JsonObject)this.NODE.read();
        JsonObject vertxData = data.getJsonObject(KEY);
        LOGGER.info("[ ZERO ] The raw data ( node = {0}, type = {1} ) before validation is {2}.", new Object[]{KEY, this.getClass().getSimpleName(), vertxData});
        Fn.shuntZero(() -> Ruler.verify((String)KEY, (JsonObject)vertxData), (Object[])new Object[]{vertxData});
        this.clusterOptions = (ClusterOptions)this.clusterTransformer.transform(data.getJsonObject("clustered"));
        return this.visit(vertxData.getJsonArray("instance"));
    }

    public ClusterOptions getCluster() {
        return this.clusterOptions;
    }

    private ConcurrentMap<String, VertxOptions> visit(JsonArray vertxData) throws ZeroException {
        ConcurrentHashMap<String, VertxOptions> map = new ConcurrentHashMap<String, VertxOptions>();
        boolean clustered = this.clusterOptions.isEnabled();
        Ut.etJArray((JsonArray)vertxData, JsonObject.class, (item, index) -> {
            String name = item.getString("name");
            VertxOptions options = (VertxOptions)this.transformer.transform(item);
            Fn.outZero((clustered != options.isClustered() ? 1 : 0) != 0, (Annal)LOGGER, ClusterConflictException.class, (Object[])new Object[]{this.getClass(), name, options.toString()});
            map.put(name, options);
        });
        return map;
    }
}

