/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up;

import io.vertx.core.ClusterOptions;
import io.vertx.core.VertxOptions;
import io.vertx.core.eventbus.EnvelopCodec;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.MessageCodec;
import io.vertx.core.spi.cluster.ClusterManager;
import io.vertx.up.atom.Envelop;
import io.vertx.up.exception.VertxCallbackException;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroGrid;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class Motor {
    public static <T> void start(Class<?> clazz, Consumer<T> consumer, Consumer<Consumer<T>> fnSingle, BiConsumer<ClusterManager, Consumer<T>> fnCluster, Annal logger) {
        if (null == consumer) {
            throw new VertxCallbackException(clazz);
        }
        ClusterOptions cluster = ZeroGrid.getClusterOption();
        if (cluster.isEnabled()) {
            ClusterManager manager = cluster.getManager();
            logger.info("[ ZERO ] Current app is running in cluster mode, manager = {0} on node {1} with status = {2}.", new Object[]{manager.getClass().getName(), manager.getNodeID(), manager.isActive()});
            fnCluster.accept(manager, consumer);
        } else {
            fnSingle.accept(consumer);
        }
    }

    public static void each(BiConsumer<String, VertxOptions> consumer) {
        ConcurrentMap<String, VertxOptions> vertxOptions = ZeroGrid.getVertxOptions();
        vertxOptions.forEach(consumer);
    }

    public static void codec(EventBus eventBus) {
        eventBus.registerDefaultCodec(Envelop.class, (MessageCodec)Instance.singleton(EnvelopCodec.class, (Object[])new Object[0]));
    }
}

