/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.atom;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpStatusCode;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.up.exception.IndexExceedException;
import io.vertx.up.exception.WebException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.web.ZeroSerializer;
import java.io.Serializable;

public class Envelop
implements Serializable {
    private static final Annal LOGGER = Annal.get(Envelop.class);
    private HttpStatusCode status = HttpStatusCode.OK;
    private MultiMap headers;
    private final WebException error;
    private final JsonObject data;
    private User user;

    public boolean valid() {
        return null == this.error;
    }

    public JsonObject data() {
        return null != this.data && this.data.containsKey("data") ? this.data.getJsonObject("data") : this.data;
    }

    public <T> T data(Class<T> clazz) {
        T reference = null;
        if (this.data.containsKey("data")) {
            reference = this.extract(this.data.getValue("data"), clazz);
        }
        return reference;
    }

    public <T> T data(Integer argIndex, Class<T> clazz) {
        String key;
        JsonObject raw;
        T reference = null;
        Fn.flingUp((0 > argIndex ? 1 : 0) != 0, (Annal)LOGGER, IndexExceedException.class, (Object[])new Object[]{this.getClass(), argIndex});
        if (this.data.containsKey("data") && null != (raw = this.data.getJsonObject("data")) && raw.containsKey(key = argIndex.toString())) {
            reference = this.extract(raw.getValue(key), clazz);
        }
        return reference;
    }

    private <T> T extract(Object value, Class<T> clazz) {
        Object reference = null;
        if (null != value) {
            Object result = ZeroSerializer.getValue(clazz, value.toString());
            reference = Fn.get(() -> result, (Object[])new Object[]{result});
        }
        return (T)reference;
    }

    public String response() {
        JsonObject response = null == this.error ? this.data : this.fail(this.error);
        return response.encode();
    }

    public HttpStatusCode status() {
        return this.status;
    }

    public User user() {
        return this.user;
    }

    public MultiMap headers() {
        return this.headers;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setHeaders(MultiMap headers) {
        this.headers = headers;
    }

    private <T> Envelop(T data) {
        this.data = this.build(ZeroSerializer.toSupport(data));
        this.error = null;
        this.status = HttpStatusCode.OK;
    }

    private <T> JsonObject build(T input) {
        JsonObject data = new JsonObject();
        HttpStatusCode status = null == this.error ? HttpStatusCode.OK : this.error.getStatus();
        data.put("data", input);
        return data;
    }

    public static Envelop ok() {
        return Envelop.success(null);
    }

    public static <T> Envelop success(T entity) {
        return new Envelop(entity);
    }

    public static Envelop failure(WebException error) {
        return new Envelop(error);
    }

    private Envelop(WebException error) {
        this.status = error.getStatus();
        this.error = error;
        this.data = this.fail(error);
    }

    private JsonObject fail(WebException error) {
        JsonObject data = new JsonObject();
        data.put("code", Integer.valueOf(error.getCode()));
        data.put("message", error.getMessage());
        if (null != error.getReadible()) {
            data.put("info", error.getReadible());
        }
        return data;
    }
}

