/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.exception;

import io.vertx.core.http.HttpStatusCode;
import io.vertx.zero.exception.ZeroRunException;
import io.vertx.zero.log.Errors;

public abstract class WebException
extends ZeroRunException {
    private final String message;
    protected HttpStatusCode status;
    private String readible;

    public WebException(String message) {
        super(message);
        this.message = message;
        this.status = HttpStatusCode.BAD_REQUEST;
    }

    public WebException(Class<?> clazz, Object ... args) {
        super("");
        this.message = Errors.normalize(clazz, (int)this.getCode(), (Object[])args);
        this.status = HttpStatusCode.BAD_REQUEST;
    }

    public abstract int getCode();

    public String getMessage() {
        return this.message;
    }

    public HttpStatusCode getStatus() {
        return this.status;
    }

    public void setReadible(String readible) {
        this.readible = readible;
    }

    public void setStatus(HttpStatusCode status) {
        this.status = status;
    }

    public String getReadible() {
        return this.readible;
    }
}

