/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.media;

import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.atom.Event;
import io.vertx.up.exception.WebException;
import io.vertx.up.media.Analyzer;
import io.vertx.up.media.MediaAtom;
import io.vertx.up.media.parse.EpsilonIncome;
import io.vertx.up.media.parse.Income;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import java.util.List;
import javax.ws.rs.core.MediaType;

public class MediaAnalyzer
implements Analyzer {
    private final transient Income<List<Epsilon<Object>>> income = (Income)Instance.singleton(EpsilonIncome.class, (Object[])new Object[0]);

    @Override
    public Object[] in(RoutingContext context, Event event) throws WebException {
        MediaType requestMedia = this.getMedia(context);
        MediaAtom.accept(event, requestMedia);
        List<Epsilon<Object>> epsilons = this.income.in(context, event);
        return epsilons.stream().map(Epsilon::getValue).toArray();
    }

    @Override
    public Envelop out(Envelop envelop, Event event) throws WebException {
        return null;
    }

    private MediaType getMedia(RoutingContext context) {
        String header = context.request().getHeader("Content-Type");
        if (StringUtil.isNil((String)header)) {
            return MediaType.WILDCARD_TYPE;
        }
        return MediaType.valueOf((String)header);
    }
}

