/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.media.parse;

import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.eon.em.MimeFlow;
import io.vertx.up.exception.WebException;
import io.vertx.up.log.Annal;
import io.vertx.up.media.Resolver;
import io.vertx.up.media.parse.Atomic;
import io.vertx.up.media.parse.StandardAtomic;
import io.vertx.up.media.parse.TypedAtomic;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.zero.marshal.node.Node;
import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;

public class MimeAtomic<T>
implements Atomic<T> {
    private static final Node<JsonObject> NODE = Node.infix((String)"resolver");
    private static final Annal LOGGER = Annal.get(MimeAtomic.class);

    @Override
    public Epsilon<T> ingest(RoutingContext context, Epsilon<T> income) throws WebException {
        Epsilon<T> epsilon;
        if (MimeFlow.TYPED == income.getMime()) {
            Atomic atomic = (Atomic)Instance.singleton(TypedAtomic.class, (Object[])new Object[0]);
            epsilon = atomic.ingest(context, income);
        } else if (MimeFlow.STANDARD == income.getMime()) {
            Atomic atomic = (Atomic)Instance.singleton(StandardAtomic.class, (Object[])new Object[0]);
            epsilon = atomic.ingest(context, income);
        } else {
            Resolver<T> resolver = this.getResolver(context, income);
            epsilon = resolver.resolve(context, income);
        }
        return epsilon;
    }

    private Resolver<T> getResolver(RoutingContext context, Epsilon<T> income) {
        Annotation annotation = income.getAnnotation();
        Class resolverCls = (Class)Instance.invoke((Object)annotation, (String)"resolver", (Object[])new Object[0]);
        if (null == resolverCls) {
            String resolver;
            JsonObject content = (JsonObject)NODE.read();
            String header = context.request().getHeader("Content-Type");
            if (null == header) {
                resolver = content.getString("default");
            } else {
                MediaType type = MediaType.valueOf((String)header);
                JsonObject resolverMap = content.getJsonObject(type.getType());
                resolver = resolverMap.getString(type.getSubtype());
            }
            LOGGER.info("[ ZERO ] ( Resolver ) Select resolver {0} for Content-Type {1} when request to {2}", new Object[]{resolver, header, context.request().absoluteURI()});
            return (Resolver)Instance.singleton((String)resolver, (Object[])new Object[0]);
        }
        LOGGER.info("[ ZERO ] ( Resolver ) Select resolver from annotation config: {0}.", new Object[]{resolverCls});
        return (Resolver)Instance.singleton((Class)resolverCls, (Object[])new Object[0]);
    }
}

