/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.media.parse;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.FileUpload;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.up.atom.Epsilon;
import io.vertx.up.exception.WebException;
import io.vertx.up.media.parse.Atomic;
import java.util.Set;

public class TypedAtomic<T>
implements Atomic<T> {
    @Override
    public Epsilon<T> ingest(RoutingContext context, Epsilon<T> income) throws WebException {
        Object returnValue = null;
        Class<?> paramType = income.getArgType();
        if (this.is(Session.class, paramType)) {
            returnValue = context.session();
        } else if (this.is(HttpServerRequest.class, paramType)) {
            returnValue = context.request();
        } else if (this.is(HttpServerResponse.class, paramType)) {
            returnValue = context.response();
        } else if (this.is(Vertx.class, paramType)) {
            returnValue = context.vertx();
        } else if (this.is(EventBus.class, paramType)) {
            returnValue = context.vertx().eventBus();
        } else if (this.is(User.class, paramType)) {
            returnValue = context.user();
        } else if (this.is(Set.class, paramType)) {
            Class<?> type = paramType.getComponentType();
            if (this.is(FileUpload.class, type)) {
                returnValue = context.fileUploads();
            }
        } else if (this.is(JsonArray.class, paramType)) {
            returnValue = context.getBodyAsJsonArray();
        } else if (this.is(JsonObject.class, paramType)) {
            returnValue = context.getBodyAsJson();
        } else if (this.is(Buffer.class, paramType)) {
            returnValue = context.getBody();
        }
        return null == returnValue ? income.setValue(null) : income.setValue(returnValue);
    }

    private boolean is(Class<?> expected, Class<?> paramType) {
        return expected == paramType || expected.isAssignableFrom(paramType);
    }
}

