/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.up.annotations.Agent;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.Pool;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.router.EventAxis;
import io.vertx.up.rs.router.RouterAxis;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroGrid;
import java.text.MessageFormat;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

@Agent
public class ZeroHttpAgent
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroHttpAgent.class);
    private static final ConcurrentMap<Integer, HttpServerOptions> SERVERS = ZeroGrid.getServerOptions();
    private static final ConcurrentMap<Integer, AtomicInteger> LOGS = new ConcurrentHashMap<Integer, AtomicInteger>(){
        {
            SERVERS.forEach((port, option) -> this.put(port, new AtomicInteger(0)));
        }
    };
    private final transient String NAME = ((Object)((Object)this)).getClass().getSimpleName();

    public void start() {
        Axis routerAxiser = (Axis)Fn.poolThread(Pool.ROUTERS, () -> (Axis)Instance.instance(RouterAxis.class, (Object[])new Object[0]));
        Axis axiser = (Axis)Fn.poolThread(Pool.EVENTS, () -> (Axis)Instance.instance(EventAxis.class, (Object[])new Object[0]));
        SERVERS.forEach((port, option) -> {
            HttpServer server = this.vertx.createHttpServer(option);
            Router router = Router.router((Vertx)this.vertx);
            routerAxiser.mount(router);
            axiser.mount(router);
            server.requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen();
            this.recordServer((HttpServerOptions)option, router);
        });
    }

    private void recordServer(HttpServerOptions options, Router router) {
        Integer port = options.getPort();
        AtomicInteger out = (AtomicInteger)LOGS.get(port);
        if (0 == out.getAndIncrement()) {
            String portLiteral = String.valueOf(port);
            LOGGER.info("[ ZERO ] ( Http Server ) {0} (id = {1}) Agent has deployed HTTP Server on {2}.", new Object[]{this.NAME, this.deploymentID(), portLiteral});
            List routes = router.getRoutes();
            for (Route route : routes) {
                String path = null == route.getPath() ? "/*" : route.getPath();
                LOGGER.info("[ ZERO ] ( Uri Register ) \"{1}\" has been deployed by {0}, Options = {2}.", new Object[]{this.NAME, path, route.toString()});
            }
            String address = MessageFormat.format("http://{0}:{1}/", options.getHost(), portLiteral);
            LOGGER.info("[ ZERO ] ( Http Server ) {0} Http Server has been started successfully. Endpoint: {1}.", new Object[]{this.NAME, address});
        }
    }
}

