/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.micro;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.up.annotations.Worker;
import io.vertx.up.atom.Envelop;
import io.vertx.up.atom.Receipt;
import io.vertx.up.exception.AsyncSignatureException;
import io.vertx.up.exception.WorkerArgumentException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;
import java.lang.reflect.Method;
import java.util.Set;

@Worker
public class ZeroHttpWorker
extends AbstractVerticle {
    private static final Annal LOGGER = Annal.get(ZeroHttpWorker.class);
    private static final Set<Receipt> RECEIPTS = ZeroAnno.getReceipts();

    public void start() {
        EventBus bus = this.vertx.eventBus();
        for (Receipt receipt : RECEIPTS) {
            String address = receipt.getAddress();
            Object reference = receipt.getProxy();
            Method method = receipt.getMethod();
            this.verify(method);
            try {
                Fn.safeNull(() -> bus.consumer(address, message -> {
                    if (this.isVoid(method)) {
                        Instance.invoke((Object)reference, (String)method.getName(), (Object[])new Object[]{message});
                    } else {
                        this.syncReply((Message<Envelop>)message, reference, method.getName());
                    }
                }), (Object[])new Object[]{address, reference, method});
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }

    private void syncReply(Message<Envelop> message, Object reference, String name) {
        Envelop envelop = (Envelop)message.body();
        Envelop reply = (Envelop)Instance.invoke((Object)reference, (String)name, (Object[])new Object[]{envelop});
        message.reply((Object)reply);
    }

    private boolean isVoid(Method method) {
        Class<?> returnType = method.getReturnType();
        return Void.TYPE == returnType || Void.class == returnType;
    }

    private void verify(Method method) {
        Class<?>[] params = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        Fn.flingUp((1 != params.length ? 1 : 0) != 0, (Annal)LOGGER, WorkerArgumentException.class, (Object[])new Object[]{((Object)((Object)this)).getClass(), method});
        Class<?> paramCls = params[0];
        Fn.safeSemi((boolean)this.isVoid(method), (Annal)LOGGER, () -> this.verify(Message.class != paramCls, returnType, paramCls), () -> this.verify(Envelop.class != paramCls || Envelop.class != returnType, returnType, paramCls));
    }

    private void verify(boolean condition, Class<?> returnType, Class<?> paramType) {
        Fn.flingUp((boolean)condition, (Annal)LOGGER, AsyncSignatureException.class, (Object[])new Object[]{((Object)((Object)this)).getClass(), returnType.getName(), paramType.getName()});
    }
}

