/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.config;

import com.google.common.collect.Sets;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.up.annotations.EndPoint;
import io.vertx.up.atom.Event;
import io.vertx.up.atom.Virtual;
import io.vertx.up.exception.AccessProxyException;
import io.vertx.up.exception.EventSourceException;
import io.vertx.up.exception.NoArgConstructorException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Extractor;
import io.vertx.up.rs.config.MediaResolver;
import io.vertx.up.rs.config.MethodResolver;
import io.vertx.up.rs.config.PathResolver;
import io.vertx.up.tool.StringUtil;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroHelper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Path;

public class EventExtractor
implements Extractor<Set<Event>> {
    private static final Annal LOGGER = Annal.get(EventExtractor.class);

    @Override
    public Set<Event> extract(Class<?> clazz) {
        return (Set)Fn.get((Object)Sets.newConcurrentHashSet(), () -> {
            this.verify(clazz);
            ConcurrentHashSet result = new ConcurrentHashSet();
            Fn.safeSemi((boolean)clazz.isAnnotationPresent(Path.class), (Annal)LOGGER, () -> this.lambda$null$0(clazz, (Set)result), () -> this.lambda$null$1((Set)result, clazz));
            return result;
        }, (Object[])new Object[]{clazz});
    }

    private void verify(Class<?> clazz) {
        if (!clazz.isInterface()) {
            Fn.flingUp((!Instance.noarg(clazz) ? 1 : 0) != 0, (Annal)LOGGER, NoArgConstructorException.class, (Object[])new Object[]{this.getClass(), clazz});
        }
        Fn.flingUp((!Modifier.isPublic(clazz.getModifiers()) ? 1 : 0) != 0, (Annal)LOGGER, AccessProxyException.class, (Object[])new Object[]{this.getClass(), clazz});
        Fn.flingUp((!clazz.isAnnotationPresent(EndPoint.class) ? 1 : 0) != 0, (Annal)LOGGER, EventSourceException.class, (Object[])new Object[]{this.getClass(), clazz.getName()});
    }

    private Set<Event> extract(Class<?> clazz, String root) {
        Method[] methods;
        HashSet<Event> events = new HashSet<Event>();
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Event event = this.extract(method, root);
            if (null == event) continue;
            events.add(event);
        }
        return events;
    }

    private Event extract(Method method, String root) {
        Class implClass;
        Event event = new Event();
        HttpMethod httpMethod = MethodResolver.resolve(method);
        if (null == httpMethod) {
            return null;
        }
        event.setMethod(httpMethod);
        Path path = ZeroHelper.getPath(method);
        if (null == path) {
            if (!StringUtil.isNil((String)root)) {
                event.setPath(root);
            }
        } else {
            String result = PathResolver.resolve(path, root);
            event.setPath(result);
        }
        event.setAction(method);
        event.setConsumes(MediaResolver.consumes(method));
        event.setProduces(MediaResolver.produces(method));
        Class<?> clazz = method.getDeclaringClass();
        Object proxy = clazz.isInterface() ? (null != (implClass = Instance.uniqueChild(clazz)) ? Instance.singleton((Class)implClass, (Object[])new Object[0]) : Virtual.create()) : Instance.singleton(method.getDeclaringClass(), (Object[])new Object[0]);
        event.setProxy(proxy);
        return event;
    }

    private /* synthetic */ void lambda$null$1(Set result, Class clazz) {
        result.addAll(this.extract(clazz, null));
    }

    private /* synthetic */ void lambda$null$0(Class clazz, Set result) {
        Path path = ZeroHelper.getPath(clazz);
        assert (null != path) : "Path should not be null.";
        result.addAll(this.extract(clazz, PathResolver.resolve(path)));
    }
}

