/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.config;

import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.tool.mirror.Instance;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

class MediaResolver {
    private static final Annal LOGGER = Annal.get(MediaResolver.class);
    private static final Set<MediaType> DEFAULTS = new HashSet<MediaType>(){
        {
            this.add(MediaType.WILDCARD_TYPE);
        }
    };

    MediaResolver() {
    }

    public static Set<MediaType> consumes(Method method) {
        return MediaResolver.resolve(method, Consumes.class);
    }

    public static Set<MediaType> produces(Method method) {
        return MediaResolver.resolve(method, Produces.class);
    }

    private static Set<MediaType> resolve(Method method, Class<? extends Annotation> mediaCls) {
        return (Set)Fn.get(() -> {
            Object anno = method.getAnnotation(mediaCls);
            return (Set)Fn.getSemi((null == anno ? 1 : 0) != 0, (Annal)LOGGER, () -> DEFAULTS, () -> {
                String[] value = (String[])Instance.invoke((Object)anno, (String)"value", (Object[])new Object[0]);
                HashSet<MediaType> result = new HashSet<MediaType>();
                for (String item : value) {
                    MediaType type;
                    if (null == item || null == (type = MediaType.valueOf((String)item))) continue;
                    result.add(type);
                }
                return result.isEmpty() ? DEFAULTS : result;
            });
        }, (Object[])new Object[]{method, mediaCls});
    }
}

