/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.dispatcher;

import io.vertx.core.eventbus.Message;
import io.vertx.up.annotations.Address;
import io.vertx.up.atom.Event;
import io.vertx.up.atom.Receipt;
import io.vertx.up.exception.ReturnTypeException;
import io.vertx.up.exception.WorkerMissingException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.rs.Aim;
import io.vertx.up.rs.dispatcher.Pool;
import io.vertx.up.rs.hunt.AsyncAim;
import io.vertx.up.rs.hunt.BlockAim;
import io.vertx.up.rs.hunt.OneWayAim;
import io.vertx.up.rs.hunt.SyncAim;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;
import java.lang.reflect.Method;
import java.util.Set;

public class ModeSplitter {
    private static final Annal LOGGER = Annal.get(ModeSplitter.class);
    private static final Set<Receipt> RECEIPTS = ZeroAnno.getReceipts();

    public Aim distribute(Event event) {
        return (Aim)Fn.get(() -> {
            boolean annotated = event.getAction().isAnnotationPresent(Address.class);
            Method method = event.getAction();
            Class<?> returnType = method.getReturnType();
            Aim aim = null;
            if (annotated) {
                if (Void.class == returnType || Void.TYPE == returnType) {
                    Fn.flingUp((boolean)true, (Annal)LOGGER, ReturnTypeException.class, (Object[])new Object[]{this.getClass(), method});
                } else {
                    Method replier = this.findReplier(event);
                    Class<?> replierType = replier.getReturnType();
                    aim = Void.class == replierType || Void.TYPE == replierType ? (this.isAsync(replier) ? (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "5"), () -> (Aim)Instance.instance(AsyncAim.class, (Object[])new Object[0])) : (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "3"), () -> (Aim)Instance.instance(OneWayAim.class, (Object[])new Object[0]))) : (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "1"), () -> (Aim)Instance.instance(AsyncAim.class, (Object[])new Object[0]));
                }
            } else {
                aim = Void.class == returnType || Void.TYPE == returnType ? (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "4"), () -> (Aim)Instance.instance(BlockAim.class, (Object[])new Object[0])) : (Aim)Fn.pool(Pool.AIMS, (Object)(Thread.currentThread().getName() + "2"), () -> (Aim)Instance.instance(SyncAim.class, (Object[])new Object[0]));
            }
            return aim;
        }, (Object[])new Object[]{event, event.getAction()});
    }

    private boolean isAsync(Method method) {
        Class<?> argumentCls;
        boolean async = false;
        Class<?>[] paramTypes = method.getParameterTypes();
        if (1 == paramTypes.length && Message.class == (argumentCls = paramTypes[0])) {
            async = true;
        }
        return async;
    }

    private Method findReplier(Event event) {
        Address annotation = event.getAction().getDeclaredAnnotation(Address.class);
        String address = (String)Instance.invoke((Object)annotation, (String)"value", (Object[])new Object[0]);
        Receipt found = RECEIPTS.stream().filter(item -> address.equals(item.getAddress())).findFirst().orElse(null);
        Fn.flingUp((null == found ? 1 : 0) != 0, (Annal)LOGGER, WorkerMissingException.class, (Object[])new Object[]{this.getClass(), address});
        Method method = found.getMethod();
        Fn.flingUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, WorkerMissingException.class, (Object[])new Object[]{this.getClass(), address});
        return method;
    }
}

