/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.up.rs.router;

import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.up.atom.Depot;
import io.vertx.up.atom.Event;
import io.vertx.up.exception.AnnotationRepeatException;
import io.vertx.up.exception.EventActionNoneException;
import io.vertx.up.exception.ParamAnnotationException;
import io.vertx.up.func.Fn;
import io.vertx.up.log.Annal;
import io.vertx.up.micro.ZeroHttpEndurer;
import io.vertx.up.rs.Aim;
import io.vertx.up.rs.Axis;
import io.vertx.up.rs.Filler;
import io.vertx.up.rs.Sentry;
import io.vertx.up.rs.dispatcher.ModeSplitter;
import io.vertx.up.rs.router.Hub;
import io.vertx.up.rs.router.MediaHub;
import io.vertx.up.rs.router.Pool;
import io.vertx.up.rs.router.UriHub;
import io.vertx.up.rs.sentry.StandardVerifier;
import io.vertx.up.tool.mirror.Anno;
import io.vertx.up.tool.mirror.Instance;
import io.vertx.up.web.ZeroAnno;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.BodyParam;
import javax.ws.rs.StreamParam;

public class EventAxis
implements Axis {
    private static final Annal LOGGER = Annal.get(EventAxis.class);
    private static final Set<Event> EVENTS = ZeroAnno.getEvents();
    private final transient ModeSplitter splitter = (ModeSplitter)Fn.poolThread(Pool.THREADS, () -> (ModeSplitter)Instance.instance(ModeSplitter.class, (Object[])new Object[0]));
    private final transient Sentry verifier = (Sentry)Fn.poolThread(Pool.VERIFIERS, () -> (Sentry)Instance.instance(StandardVerifier.class, (Object[])new Object[0]));

    @Override
    public void mount(Router router) {
        EVENTS.forEach(event -> Fn.safeSemi((null == event ? 1 : 0) != 0, (Annal)LOGGER, () -> LOGGER.warn("[ ZERO ] ( {0} ) The system found \"null\" event in the queue. ", new Object[]{this.getClass().getName()}), () -> {
            this.verify((Event)event);
            Route route = router.route();
            Hub hub = (Hub)Fn.poolThread(Pool.URIHUBS, () -> (Hub)Instance.instance(UriHub.class, (Object[])new Object[0]));
            hub.mount(route, (Event)event);
            hub = (Hub)Fn.poolThread(Pool.MEDIAHUBS, () -> (Hub)Instance.instance(MediaHub.class, (Object[])new Object[0]));
            hub.mount(route, (Event)event);
            Depot depot = Depot.create(event);
            Aim aim = this.splitter.distribute((Event)event);
            route.handler(this.verifier.signal(depot)).handler(aim.attack((Event)event)).failureHandler(ZeroHttpEndurer.create());
        }));
    }

    private void verify(Event event) {
        Method method = event.getAction();
        Fn.flingUp((null == method ? 1 : 0) != 0, (Annal)LOGGER, EventActionNoneException.class, (Object[])new Object[]{this.getClass(), event});
        this.verify(method, BodyParam.class);
        this.verify(method, StreamParam.class);
        for (Parameter parameter : method.getParameters()) {
            this.verify(parameter);
        }
    }

    private void verify(Method method, Class<? extends Annotation> annoCls) {
        Annotation[][] annotations = method.getParameterAnnotations();
        int occurs = Anno.occurs((Annotation[][])annotations, annoCls);
        Fn.flingUp((1 < occurs ? 1 : 0) != 0, (Annal)LOGGER, AnnotationRepeatException.class, (Object[])new Object[]{this.getClass(), method.getName(), annoCls, occurs});
    }

    private void verify(Parameter parameter) {
        Annotation[] annotations = parameter.getDeclaredAnnotations();
        List annotationList = Arrays.stream(annotations).filter(item -> Filler.PARAMS.containsKey(item.annotationType())).collect(Collectors.toList());
        int multi = annotationList.size();
        Fn.flingUp((1 < multi ? 1 : 0) != 0, (Annal)LOGGER, ParamAnnotationException.class, (Object[])new Object[]{this.getClass(), parameter.getName(), multi});
    }
}

